/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.AbstractTransactionManagementConfiguration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@ConditionalOnClass(value={JdbcTemplate.class, PlatformTransactionManager.class})
@AutoConfigureOrder(value=0x7FFFFFFF)
public class DataSourceTransactionManagerAutoConfiguration {
    @Autowired(required=false)
    private DataSource dataSource;

    @Bean
    @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
    @ConditionalOnBean(value={DataSource.class})
    public DataSourceTransactionManager transactionManager() {
        return new DataSourceTransactionManager(this.dataSource);
    }

    @ConditionalOnMissingBean(value={AbstractTransactionManagementConfiguration.class})
    @Configuration
    @EnableTransactionManagement
    protected static class TransactionManagementConfiguration {
        protected TransactionManagementConfiguration() {
        }
    }
}

