/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.social;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.social.FacebookProperties;
import org.springframework.boot.autoconfigure.social.SocialAutoConfigurerAdapter;
import org.springframework.boot.autoconfigure.social.SocialWebAutoConfiguration;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.social.config.annotation.EnableSocial;
import org.springframework.social.config.annotation.SocialConfigurerAdapter;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.web.GenericConnectionStatusView;
import org.springframework.social.facebook.api.Facebook;
import org.springframework.social.facebook.connect.FacebookConnectionFactory;
import org.springframework.web.servlet.View;

@Configuration
@ConditionalOnClass(value={SocialConfigurerAdapter.class, FacebookConnectionFactory.class})
@ConditionalOnProperty(prefix="spring.social.facebook", name={"app-id"})
@AutoConfigureBefore(value={SocialWebAutoConfiguration.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class FacebookAutoConfiguration {

    @Configuration
    @EnableSocial
    @EnableConfigurationProperties(value={FacebookProperties.class})
    @ConditionalOnWebApplication
    protected static class FacebookConfigurerAdapter
    extends SocialAutoConfigurerAdapter {
        @Autowired
        private FacebookProperties properties;

        protected FacebookConfigurerAdapter() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Facebook.class})
        @Scope(value="request", proxyMode=ScopedProxyMode.INTERFACES)
        public Facebook facebook(ConnectionRepository repository) {
            Connection connection = repository.findPrimaryConnection(Facebook.class);
            return connection != null ? (Facebook)connection.getApi() : null;
        }

        @Bean(name={"connect/facebookConnect", "connect/facebookConnected"})
        @ConditionalOnProperty(prefix="spring.social", name={"auto-connection-views"})
        public View facebookConnectView() {
            return new GenericConnectionStatusView("facebook", "Facebook");
        }

        @Override
        protected ConnectionFactory<?> createConnectionFactory() {
            return new FacebookConnectionFactory(this.properties.getAppId(), this.properties.getAppSecret());
        }
    }
}

