/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.GlobalAuthenticationConfigurerAdapter;

@Configuration
@ConditionalOnClass(value={GlobalAuthenticationConfigurerAdapter.class})
public class BootGlobalAuthenticationConfiguration {
    @Bean
    public static BootGlobalAuthenticationConfigurationAdapter bootGlobalAuthenticationConfigurationAdapter(ApplicationContext context) {
        return new BootGlobalAuthenticationConfigurationAdapter(context);
    }

    private static class BootGlobalAuthenticationConfigurationAdapter
    extends GlobalAuthenticationConfigurerAdapter {
        private static Log logger = LogFactory.getLog(BootGlobalAuthenticationConfiguration.class);
        private final ApplicationContext context;

        public BootGlobalAuthenticationConfigurationAdapter(ApplicationContext context) {
            this.context = context;
        }

        public void init(AuthenticationManagerBuilder auth) {
            Map beansWithAnnotation = this.context.getBeansWithAnnotation(EnableAutoConfiguration.class);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Eagerly initializing " + beansWithAnnotation));
            }
        }
    }
}

