/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jmx;

import javax.management.MBeanServer;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.jmx.ParentAwareNamingStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableMBeanExport;
import org.springframework.context.annotation.MBeanExportConfiguration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.annotation.AnnotationMBeanExporter;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.jmx.support.MBeanServerFactoryBean;
import org.springframework.jmx.support.WebSphereMBeanServerFactoryBean;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnClass(value={MBeanExporter.class})
@ConditionalOnProperty(prefix="spring.jmx", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class JmxAutoConfiguration {
    @Autowired
    private Environment environment;
    @Autowired
    private BeanFactory beanFactory;
    @Autowired
    private ObjectNamingStrategy namingStrategy;

    @Bean
    @ConditionalOnMissingBean(value={MBeanExporter.class}, search=SearchStrategy.CURRENT)
    public AnnotationMBeanExporter mbeanExporter() {
        MBeanExportConfiguration config = new MBeanExportConfiguration();
        config.setEnvironment(this.environment);
        config.setBeanFactory(this.beanFactory);
        config.setImportMetadata((AnnotationMetadata)new StandardAnnotationMetadata(Empty.class));
        AnnotationMBeanExporter exporter = config.mbeanExporter();
        exporter.setNamingStrategy(this.namingStrategy);
        return exporter;
    }

    @Bean
    @ConditionalOnMissingBean(value={ObjectNamingStrategy.class})
    public ParentAwareNamingStrategy objectNamingStrategy() {
        return new ParentAwareNamingStrategy((JmxAttributeSource)new AnnotationJmxAttributeSource());
    }

    @Bean
    @ConditionalOnMissingBean(value={MBeanServer.class})
    public MBeanServer mbeanServer() {
        SpecificPlatform platform = SpecificPlatform.get();
        if (platform != null) {
            return platform.getMBeanServer();
        }
        MBeanServerFactoryBean factory = new MBeanServerFactoryBean();
        factory.setLocateExistingServerIfPossible(true);
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    private static enum SpecificPlatform {
        WEBLOGIC("weblogic.management.Helper"){

            @Override
            public FactoryBean<?> getMBeanServerFactory() {
                JndiObjectFactoryBean factory = new JndiObjectFactoryBean();
                factory.setJndiName("java:comp/env/jmx/runtime");
                return factory;
            }
        }
        ,
        WEBSPHERE("com.ibm.websphere.management.AdminServiceFactory"){

            public FactoryBean<MBeanServer> getMBeanServerFactory() {
                return new WebSphereMBeanServerFactoryBean();
            }
        };

        private final String identifyingClass;

        private SpecificPlatform(String identifyingClass) {
            this.identifyingClass = identifyingClass;
        }

        public MBeanServer getMBeanServer() {
            try {
                FactoryBean<?> factory = this.getMBeanServerFactory();
                if (factory instanceof InitializingBean) {
                    ((InitializingBean)factory).afterPropertiesSet();
                }
                Object server = factory.getObject();
                Assert.isInstanceOf(MBeanServer.class, (Object)server);
                return (MBeanServer)server;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }

        protected abstract FactoryBean<?> getMBeanServerFactory();

        public static SpecificPlatform get() {
            ClassLoader classLoader = MBeanExportConfiguration.class.getClassLoader();
            for (SpecificPlatform environment : SpecificPlatform.values()) {
                if (!ClassUtils.isPresent((String)environment.identifyingClass, (ClassLoader)classLoader)) continue;
                return environment;
            }
            return null;
        }
    }

    @EnableMBeanExport(defaultDomain="${spring.jmx.default_domain:}", server="${spring.jmx.server:mbeanServer}")
    private static class Empty {
        private Empty() {
        }
    }
}

