/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.groovy.template;

import groovy.text.SimpleTemplateEngine;
import groovy.text.TemplateEngine;
import groovy.text.markup.MarkupTemplateEngine;
import groovy.text.markup.TemplateConfiguration;
import groovy.text.markup.TemplateResolver;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.servlet.Servlet;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.groovy.template.GroovyTemplateProperties;
import org.springframework.boot.autoconfigure.groovy.template.GroovyTemplateResolver;
import org.springframework.boot.autoconfigure.groovy.template.web.GroovyTemplateViewResolver;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.servlet.view.UrlBasedViewResolver;

@Configuration
@ConditionalOnClass(value={TemplateEngine.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={GroovyTemplateProperties.class})
public class GroovyTemplateAutoConfiguration {
    @Autowired
    private final ResourceLoader resourceLoader = new DefaultResourceLoader();
    @Autowired
    private GroovyTemplateProperties properties;

    @Configuration
    @ConditionalOnClass(value={Servlet.class, LocaleContextHolder.class, UrlBasedViewResolver.class})
    @ConditionalOnWebApplication
    public static class GroovyWebConfiguration {
        @Autowired
        private GroovyTemplateProperties properties;

        @Bean
        @ConditionalOnMissingBean(name={"groovyTemplateViewResolver"})
        public GroovyTemplateViewResolver groovyTemplateViewResolver(TemplateEngine engine) {
            GroovyTemplateViewResolver resolver = new GroovyTemplateViewResolver();
            resolver.setPrefix(this.properties.getPrefix());
            resolver.setSuffix(this.properties.getSuffix());
            resolver.setCache(this.properties.isCache());
            resolver.setContentType(this.properties.getContentType());
            resolver.setViewNames(this.properties.getViewNames());
            resolver.setTemplateEngine(engine);
            resolver.setOrder(0x7FFFFFF9);
            return resolver;
        }
    }

    @Configuration
    @ConditionalOnMissingClass(name={"groovy.text.markup.MarkupTemplateEngine"})
    public static class GroovySimpleConfiguration
    extends BaseGroovyTemplateConfiguration {
        @Autowired
        private GroovyTemplateProperties properties;

        @Bean
        @ConditionalOnMissingBean(value={TemplateEngine.class})
        public TemplateEngine groovyTemplateEngine() throws Exception {
            return new SimpleTemplateEngine(this.createParentLoaderForTemplates());
        }
    }

    @Configuration
    @ConditionalOnClass(value={MarkupTemplateEngine.class})
    public static class GroovyMarkupConfiguration
    extends BaseGroovyTemplateConfiguration {
        @Autowired
        private GroovyTemplateProperties properties;

        @Bean
        @ConfigurationProperties(prefix="spring.groovy.template.configuration")
        public TemplateConfiguration groovyTemplateConfiguration() {
            return new TemplateConfiguration();
        }

        @Bean
        @ConditionalOnMissingBean(value={TemplateEngine.class})
        public TemplateEngine groovyTemplateEngine() throws Exception {
            TemplateConfiguration configuration = this.groovyTemplateConfiguration();
            configuration.setCacheTemplates(this.properties.isCache());
            return new MarkupTemplateEngine(this.createParentLoaderForTemplates(), configuration, (TemplateResolver)new GroovyTemplateResolver());
        }
    }

    public static abstract class BaseGroovyTemplateConfiguration
    implements BeanClassLoaderAware {
        @Autowired
        private GroovyTemplateProperties properties;
        @Autowired
        private ApplicationContext resourceLoader;
        private ClassLoader classLoader = GroovyWebConfiguration.class.getClassLoader();

        public void setBeanClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        protected ClassLoader createParentLoaderForTemplates() throws Exception {
            Resource[] resources = this.resourceLoader.getResources(this.properties.getPrefix());
            if (resources.length > 0) {
                ArrayList<URL> urls = new ArrayList<URL>();
                for (Resource resource : resources) {
                    if (!resource.exists()) continue;
                    urls.add(resource.getURL());
                }
                return new URLClassLoader(urls.toArray(new URL[urls.size()]), this.classLoader);
            }
            return this.classLoader;
        }
    }
}

