/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.social;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.social.SocialAutoConfigurerAdapter;
import org.springframework.boot.autoconfigure.social.SocialWebAutoConfiguration;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.social.config.annotation.EnableSocial;
import org.springframework.social.config.annotation.SocialConfigurerAdapter;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.web.GenericConnectionStatusView;
import org.springframework.social.twitter.api.Twitter;
import org.springframework.social.twitter.api.impl.TwitterTemplate;
import org.springframework.social.twitter.connect.TwitterConnectionFactory;
import org.springframework.web.servlet.View;

@Configuration
@ConditionalOnClass(value={SocialConfigurerAdapter.class, TwitterConnectionFactory.class})
@ConditionalOnProperty(prefix="spring.social.twitter.", value={"app-id"})
@AutoConfigureBefore(value={SocialWebAutoConfiguration.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class TwitterAutoConfiguration {

    @Configuration
    @EnableSocial
    @ConditionalOnWebApplication
    protected static class TwitterAutoConfigurationAdapter
    extends SocialAutoConfigurerAdapter {
        protected TwitterAutoConfigurationAdapter() {
        }

        @Override
        protected String getPropertyPrefix() {
            return "spring.social.twitter.";
        }

        @Override
        protected ConnectionFactory<?> createConnectionFactory(RelaxedPropertyResolver properties) {
            return new TwitterConnectionFactory(properties.getRequiredProperty("app-id"), properties.getRequiredProperty("app-secret"));
        }

        @Bean
        @ConditionalOnMissingBean
        @Scope(value="request", proxyMode=ScopedProxyMode.INTERFACES)
        public Twitter twitter(ConnectionRepository repository) {
            Connection connection = repository.findPrimaryConnection(Twitter.class);
            if (connection != null) {
                return (Twitter)connection.getApi();
            }
            String id = this.getProperties().getRequiredProperty("app-id");
            String secret = this.getProperties().getRequiredProperty("app-secret");
            return new TwitterTemplate(id, secret);
        }

        @Bean(name={"connect/twitterConnect", "connect/twitterConnected"})
        @ConditionalOnProperty(prefix="spring.social.", value={"auto-connection-views"})
        public View twitterConnectView() {
            return new GenericConnectionStatusView("twitter", "Twitter");
        }
    }
}

