/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.jdbc.CommonsDataSourceConfiguration;
import org.springframework.boot.autoconfigure.jdbc.EmbeddedDataSourceConfiguration;
import org.springframework.boot.autoconfigure.jdbc.EmbeddedDatabaseConnection;
import org.springframework.boot.autoconfigure.jdbc.TomcatDataSourceConfiguration;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={EmbeddedDatabaseType.class})
public class DataSourceAutoConfiguration
implements EnvironmentAware {
    private static Log logger = LogFactory.getLog(DataSourceAutoConfiguration.class);
    public static final String CONFIGURATION_PREFIX = "spring.datasource";
    @Autowired(required=false)
    private DataSource dataSource;
    @Autowired
    private ApplicationContext applicationContext;
    private RelaxedPropertyResolver datasourceProperties;

    public void setEnvironment(Environment environment) {
        this.datasourceProperties = new RelaxedPropertyResolver((PropertyResolver)environment, "spring.datasource.");
    }

    @PostConstruct
    protected void initialize() throws Exception {
        boolean initialize = (Boolean)this.datasourceProperties.getProperty("initialize", Boolean.class, (Object)true);
        if (this.dataSource == null || !initialize) {
            logger.debug((Object)"No DataSource found so not initializing");
            return;
        }
        String schema = this.datasourceProperties.getProperty("schema");
        if (schema == null) {
            schema = "classpath*:schema-" + this.datasourceProperties.getProperty("platform", "all") + ".sql,classpath*:schema.sql,classpath*:data.sql";
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String schemaLocation : StringUtils.commaDelimitedListToStringArray((String)schema)) {
            resources.addAll(Arrays.asList(this.applicationContext.getResources(schemaLocation)));
        }
        boolean continueOnError = (Boolean)this.datasourceProperties.getProperty("continueOnError", Boolean.class, (Object)false);
        boolean exists = false;
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        for (Resource resource : resources) {
            if (!resource.exists()) continue;
            exists = true;
            populator.addScript(resource);
            populator.setContinueOnError(continueOnError);
        }
        if (exists) {
            DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)this.dataSource);
        }
    }

    public static boolean containsAutoConfiguredDataSource(ConfigurableListableBeanFactory beanFactory) {
        try {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition("dataSource");
            return EmbeddedDataSourceConfiguration.class.getName().equals(beanDefinition.getFactoryBeanName());
        }
        catch (NoSuchBeanDefinitionException ex) {
            return false;
        }
    }

    static class DatabaseCondition
    extends SpringBootCondition {
        private final SpringBootCondition tomcatCondition = new TomcatDatabaseCondition();
        private final SpringBootCondition dbcpCondition = new BasicDatabaseCondition();
        private final SpringBootCondition embeddedCondition = new EmbeddedDatabaseCondition();

        DatabaseCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            if (this.anyMatches(context, metadata, this.tomcatCondition, this.dbcpCondition, this.embeddedCondition)) {
                return ConditionOutcome.match("existing auto database detected");
            }
            if (BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context.getBeanFactory(), DataSource.class, (boolean)true, (boolean)false).length > 0) {
                return ConditionOutcome.match("Existing bean configured database detected");
            }
            return ConditionOutcome.noMatch("no existing bean configured database");
        }
    }

    static class EmbeddedDatabaseCondition
    extends SpringBootCondition {
        private final SpringBootCondition tomcatCondition = new TomcatDatabaseCondition();
        private final SpringBootCondition dbcpCondition = new BasicDatabaseCondition();

        EmbeddedDatabaseCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            if (this.anyMatches(context, metadata, this.tomcatCondition, this.dbcpCondition)) {
                return ConditionOutcome.noMatch("existing non-embedded database detected");
            }
            EmbeddedDatabaseType type = EmbeddedDatabaseConnection.get(context.getClassLoader()).getType();
            if (type == null) {
                return ConditionOutcome.noMatch("no embedded database detected");
            }
            return ConditionOutcome.match("embedded database " + type + " detected");
        }
    }

    static class TomcatDatabaseCondition
    extends NonEmbeddedDatabaseCondition {
        TomcatDatabaseCondition() {
        }

        @Override
        protected String getDataSourceClassName() {
            return "org.apache.tomcat.jdbc.pool.DataSource";
        }
    }

    static class BasicDatabaseCondition
    extends NonEmbeddedDatabaseCondition {
        private final Condition tomcatCondition = new TomcatDatabaseCondition();

        BasicDatabaseCondition() {
        }

        @Override
        protected String getDataSourceClassName() {
            return "org.apache.commons.dbcp.BasicDataSource";
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            if (this.matches(context, metadata, this.tomcatCondition)) {
                return ConditionOutcome.noMatch("Tomcat DataSource");
            }
            return super.getMatchOutcome(context, metadata);
        }
    }

    static abstract class NonEmbeddedDatabaseCondition
    extends SpringBootCondition {
        NonEmbeddedDatabaseCondition() {
        }

        protected abstract String getDataSourceClassName();

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            if (!ClassUtils.isPresent((String)this.getDataSourceClassName(), (ClassLoader)context.getClassLoader())) {
                return ConditionOutcome.noMatch(this.getDataSourceClassName() + " DataSource class not found");
            }
            String driverClassName = this.getDriverClassName(context.getEnvironment(), this.getDataSourceClassLoader(context));
            if (driverClassName == null) {
                return ConditionOutcome.noMatch("no database driver");
            }
            String url = this.getUrl(context.getEnvironment(), context.getClassLoader());
            if (url == null) {
                return ConditionOutcome.noMatch("no database URL");
            }
            if (ClassUtils.isPresent((String)driverClassName, (ClassLoader)context.getClassLoader())) {
                return ConditionOutcome.match("found database driver " + driverClassName);
            }
            return ConditionOutcome.noMatch("missing database driver " + driverClassName);
        }

        private ClassLoader getDataSourceClassLoader(ConditionContext context) {
            try {
                Class dataSourceClass = ClassUtils.forName((String)this.getDataSourceClassName(), (ClassLoader)context.getClassLoader());
                return dataSourceClass.getClassLoader();
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private String getDriverClassName(Environment environment, ClassLoader classLoader) {
            String driverClassName;
            String string = driverClassName = environment == null ? null : environment.getProperty("spring.datasource.driverClassName");
            if (driverClassName == null) {
                driverClassName = EmbeddedDatabaseConnection.get(classLoader).getDriverClassName();
            }
            return driverClassName;
        }

        private String getUrl(Environment environment, ClassLoader classLoader) {
            String url;
            String string = url = environment == null ? null : environment.getProperty("spring.datasource.url");
            if (url == null) {
                url = EmbeddedDatabaseConnection.get(classLoader).getUrl();
            }
            return url;
        }
    }

    @Configuration
    @Conditional(value={DatabaseCondition.class})
    protected static class JdbcTemplateConfiguration {
        @Autowired(required=false)
        private DataSource dataSource;

        protected JdbcTemplateConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={JdbcOperations.class})
        public JdbcTemplate jdbcTemplate() {
            return new JdbcTemplate(this.dataSource);
        }

        @Bean
        @ConditionalOnMissingBean(value={NamedParameterJdbcOperations.class})
        public NamedParameterJdbcTemplate namedParameterJdbcTemplate() {
            return new NamedParameterJdbcTemplate(this.dataSource);
        }
    }

    @Conditional(value={BasicDatabaseCondition.class})
    @ConditionalOnMissingBean(value={DataSource.class})
    @Import(value={CommonsDataSourceConfiguration.class})
    protected static class DbcpConfiguration {
        protected DbcpConfiguration() {
        }
    }

    @Conditional(value={TomcatDatabaseCondition.class})
    @ConditionalOnMissingBean(value={DataSource.class})
    @Import(value={TomcatDataSourceConfiguration.class})
    protected static class TomcatConfiguration {
        protected TomcatConfiguration() {
        }
    }

    @Conditional(value={EmbeddedDatabaseCondition.class})
    @ConditionalOnMissingBean(value={DataSource.class})
    @Import(value={EmbeddedDataSourceConfiguration.class})
    protected static class EmbeddedConfiguration {
        protected EmbeddedConfiguration() {
        }
    }
}

