/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.springframework.batch.item.database.AbstractPagingItemReader;
import org.springframework.batch.item.database.orm.JpaQueryProvider;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaPagingItemReader<T>
extends AbstractPagingItemReader<T> {
    private EntityManagerFactory entityManagerFactory;
    private EntityManager entityManager;
    private final Map<String, Object> jpaPropertyMap = new HashMap<String, Object>();
    private String queryString;
    private JpaQueryProvider queryProvider;
    private Map<String, Object> parameterValues;

    public JpaPagingItemReader() {
        this.setName(ClassUtils.getShortName(JpaPagingItemReader.class));
    }

    private Query createQuery() {
        if (this.queryProvider == null) {
            return this.entityManager.createQuery(this.queryString);
        }
        return this.queryProvider.createQuery();
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void setParameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.queryProvider == null) {
            Assert.notNull((Object)this.entityManagerFactory);
            Assert.hasLength((String)this.queryString);
        } else {
            Assert.isTrue((this.queryProvider != null ? 1 : 0) != 0, (String)"JPA query provider must be set");
        }
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setQueryProvider(JpaQueryProvider queryProvider) {
        this.queryProvider = queryProvider;
    }

    @Override
    protected void doOpen() throws Exception {
        super.doOpen();
        this.entityManager = this.entityManagerFactory.createEntityManager(this.jpaPropertyMap);
        if (this.entityManager == null) {
            throw new DataAccessResourceFailureException("Unable to obtain an EntityManager");
        }
        if (this.queryProvider != null) {
            this.queryProvider.setEntityManager(this.entityManager);
        }
    }

    @Override
    protected void doReadPage() {
        EntityTransaction tx = this.entityManager.getTransaction();
        tx.begin();
        this.entityManager.flush();
        this.entityManager.clear();
        Query query = this.createQuery().setFirstResult(this.getPage() * this.getPageSize()).setMaxResults(this.getPageSize());
        if (this.parameterValues != null) {
            for (Map.Entry<String, Object> me : this.parameterValues.entrySet()) {
                query.setParameter(me.getKey(), me.getValue());
            }
        }
        if (this.results == null) {
            this.results = new CopyOnWriteArrayList();
        } else {
            this.results.clear();
        }
        this.results.addAll(query.getResultList());
        tx.commit();
    }

    @Override
    protected void doJumpToPage(int itemIndex) {
    }

    @Override
    protected void doClose() throws Exception {
        this.entityManager.close();
        super.doClose();
    }
}

