/*
 * Decompiled with CFR 0.152.
 */
package spire.math.poly;

import java.math.BigDecimal;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Vector;
import scala.math.BigInt;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichDouble$;
import spire.math.Interval;
import spire.math.Polynomial;
import spire.math.Polynomial$;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.SafeLong$;
import spire.math.package$;
import spire.math.poly.RootIsolator;
import spire.math.poly.Term;
import spire.std.package$bigDecimal$;
import spire.std.package$bigInt$;

public final class Roots$ {
    public static final Roots$ MODULE$;

    static {
        new Roots$();
    }

    public final <A> Vector<Interval<Rational>> isolateRoots(Polynomial<A> poly, RootIsolator<A> isolator) {
        return isolator.isolateRoots(poly);
    }

    public final Polynomial<BigInt> removeFractions(Polynomial<Rational> poly) {
        Rational[] coeffs = (Rational[])poly.coeffsArray(Rational$.MODULE$.RationalAlgebra());
        BigInt factors = (BigInt)Predef$.MODULE$.refArrayOps((Object[])coeffs).foldLeft((Object)scala.package$.MODULE$.BigInt().apply(1), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BigInt apply(BigInt acc, Rational coeff) {
                BigInt d = coeff.denominator().toBigInt();
                return acc.$times(d.$div(acc.gcd(d)));
            }
        });
        BigInt[] zCoeffs = (BigInt[])Predef$.MODULE$.refArrayOps((Object[])coeffs).map((Function1)new Serializable(factors){
            public static final long serialVersionUID = 0L;
            private final BigInt factors$1;

            public final BigInt apply(Rational n) {
                return n.numerator().$times(SafeLong$.MODULE$.apply(this.factors$1).$div(n.denominator())).toBigInt();
            }
            {
                this.factors$1 = factors$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BigInt.class)));
        return Polynomial$.MODULE$.dense(zCoeffs, package$bigInt$.MODULE$.BigIntAlgebra(), package$bigInt$.MODULE$.BigIntAlgebra(), ClassTag$.MODULE$.apply(BigInt.class));
    }

    public final Polynomial<BigInt> removeDecimal(Polynomial<scala.math.BigDecimal> poly) {
        Polynomial<BigInt> polynomial;
        Polynomial<scala.math.BigDecimal> polynomial2 = poly;
        Polynomial<scala.math.BigDecimal> polynomial3 = Polynomial$.MODULE$.zero(package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), ClassTag$.MODULE$.apply(scala.math.BigDecimal.class));
        if (!(polynomial2 != null ? !((Object)polynomial2).equals(polynomial3) : polynomial3 != null)) {
            polynomial = Polynomial$.MODULE$.zero(package$bigInt$.MODULE$.BigIntAlgebra(), package$bigInt$.MODULE$.BigIntAlgebra(), ClassTag$.MODULE$.apply(BigInt.class));
        } else {
            List terms2 = (List)poly.terms(package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Term<BigDecimal> apply(Term<scala.math.BigDecimal> x0$1) {
                    if (x0$1 != null) {
                        return new Term<BigDecimal>(x0$1.coeff().bigDecimal().stripTrailingZeros(), x0$1.exp());
                    }
                    throw new MatchError(x0$1);
                }
            }, List$.MODULE$.canBuildFrom());
            int maxScale = BoxesRunTime.unboxToInt((Object)((TraversableOnce)terms2.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Term<BigDecimal> x$1) {
                    return x$1.coeff().scale();
                }
            }, List$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
            polynomial = Polynomial$.MODULE$.apply((Iterable)terms2.map((Function1)new Serializable(maxScale){
                public static final long serialVersionUID = 0L;
                private final int maxScale$1;

                public final Term<BigInt> apply(Term<BigDecimal> x0$2) {
                    if (x0$2 != null) {
                        BigInt c0 = scala.package$.MODULE$.BigInt().apply(x0$2.coeff().movePointRight(this.maxScale$1).unscaledValue());
                        return new Term<BigInt>(c0, x0$2.exp());
                    }
                    throw new MatchError(x0$2);
                }
                {
                    this.maxScale$1 = maxScale$1;
                }
            }, List$.MODULE$.canBuildFrom()), package$bigInt$.MODULE$.BigIntAlgebra(), package$bigInt$.MODULE$.BigIntAlgebra(), ClassTag$.MODULE$.apply(BigInt.class));
        }
        return polynomial;
    }

    public final int upperBound(Polynomial<BigInt> p) {
        int lgLastCoeff = p.maxOrderTermCoeff(package$bigInt$.MODULE$.BigIntAlgebra()).abs().bitLength();
        int n = p.degree();
        DoubleRef maxBound = DoubleRef.create((double)Double.NEGATIVE_INFINITY);
        p.foreachNonZero(new Serializable(lgLastCoeff, n, maxBound){
            public static final long serialVersionUID = 0L;
            private final int lgLastCoeff$1;
            private final int n$1;
            private final DoubleRef maxBound$1;

            public final void apply(int k, BigInt coeff) {
                if (k != this.n$1) {
                    int i = this.n$1 - k;
                    int bound = (coeff.abs().bitLength() - this.lgLastCoeff$1 - 1) / i + 2;
                    this.maxBound$1.elem = package$.MODULE$.max(this.maxBound$1.elem, (double)bound);
                }
            }
            {
                this.lgLastCoeff$1 = lgLastCoeff$1;
                this.n$1 = n$1;
                this.maxBound$1 = maxBound$1;
            }
        }, package$bigInt$.MODULE$.BigIntAlgebra(), package$bigInt$.MODULE$.BigIntAlgebra());
        double d = maxBound.elem;
        Predef$ predef$ = Predef$.MODULE$;
        if (RichDouble$.MODULE$.isValidInt$extension(d)) {
            return (int)maxBound.elem;
        }
        throw new ArithmeticException("bound too large");
    }

    public int lowerBound(Polynomial<BigInt> p) {
        return -this.upperBound(p.reciprocal(package$bigInt$.MODULE$.BigIntAlgebra(), package$bigInt$.MODULE$.BigIntAlgebra()));
    }

    private Roots$() {
        MODULE$ = this;
    }
}

