/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.matcher;

import org.specs2.io.FileReader;
import org.specs2.matcher.PathBaseMatchers;
import org.specs2.matcher.PathMatcher;
import org.specs2.text.Quote$;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;

public abstract class PathBaseMatchers$class {
    public static PathMatcher beAnExistingPath(PathBaseMatchers $this) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathBaseMatchers $outer;

            public final boolean apply(String s) {
                return this.$outer.fileReader().exists(s);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "exists", "doesn't exist");
    }

    public static PathMatcher beAReadablePath(PathBaseMatchers $this) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathBaseMatchers $outer;

            public final boolean apply(String s) {
                return this.$outer.fileReader().canRead(s);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "is readable", "can't be read");
    }

    public static PathMatcher beAWritablePath(PathBaseMatchers $this) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathBaseMatchers $outer;

            public final boolean apply(String s) {
                return this.$outer.fileReader().canWrite(s);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "is writable", "can't be written");
    }

    public static PathMatcher beAnAbsolutePath(PathBaseMatchers $this) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathBaseMatchers $outer;

            public final boolean apply(String s) {
                return this.$outer.fileReader().isAbsolute(s);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "is absolute", "is not absolute");
    }

    public static PathMatcher beAHiddenPath(PathBaseMatchers $this) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathBaseMatchers $outer;

            public final boolean apply(String s) {
                return this.$outer.fileReader().isHidden(s);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "is hidden", "is not hidden");
    }

    public static PathMatcher beAFilePath(PathBaseMatchers $this) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathBaseMatchers $outer;

            public final boolean apply(String s) {
                return this.$outer.fileReader().isFile(s);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "is a file", "is not a file");
    }

    public static PathMatcher beADirectoryPath(PathBaseMatchers $this) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathBaseMatchers $outer;

            public final boolean apply(String s) {
                return this.$outer.fileReader().isDirectory(s);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "is a directory", "is not a directory");
    }

    public static PathMatcher havePathName(PathBaseMatchers $this, String name) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathBaseMatchers $outer;
            private final String name$1;

            public final boolean apply(String s) {
                return PathBaseMatchers$class.org$specs2$matcher$PathBaseMatchers$$isEqualIgnoringSep(this.$outer, this.$outer.fileReader().getName(s), this.name$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$1 = name$1;
            }
        }, new StringBuilder().append((Object)"is named ").append((Object)Quote$.MODULE$.q((Object)name)).toString(), new StringBuilder().append((Object)"is not named ").append((Object)Quote$.MODULE$.q((Object)name)).toString());
    }

    public static PathMatcher haveAsAbsolutePath(PathBaseMatchers $this, String path) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this, path){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathBaseMatchers $outer;
            private final String path$2;

            public final boolean apply(String s) {
                return PathBaseMatchers$class.org$specs2$matcher$PathBaseMatchers$$isEqualIgnoringSep(this.$outer, s, this.path$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.path$2 = path$2;
            }
        }, new StringBuilder().append((Object)"has absolute path ").append((Object)Quote$.MODULE$.q((Object)path)).toString(), new StringBuilder().append((Object)"doesn't have absolute path ").append((Object)Quote$.MODULE$.q((Object)path)).toString());
    }

    public static PathMatcher haveAsCanonicalPath(PathBaseMatchers $this, String path) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this, path){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathBaseMatchers $outer;
            private final String path$3;

            public final boolean apply(String s) {
                return PathBaseMatchers$class.org$specs2$matcher$PathBaseMatchers$$isEqualIgnoringSep(this.$outer, this.$outer.fileReader().getCanonicalPath(s), this.path$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.path$3 = path$3;
            }
        }, new StringBuilder().append((Object)"has canonical path ").append((Object)Quote$.MODULE$.q((Object)path)).toString(), new StringBuilder().append((Object)"doesn't have canonical path ").append((Object)Quote$.MODULE$.q((Object)path)).toString());
    }

    public static PathMatcher haveParentPath(PathBaseMatchers $this, String parent) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this, parent){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathBaseMatchers $outer;
            private final String parent$1;

            public final boolean apply(String s) {
                return PathBaseMatchers$class.org$specs2$matcher$PathBaseMatchers$$isEqualIgnoringSep(this.$outer, this.$outer.fileReader().getParent(s), this.parent$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.parent$1 = parent$1;
            }
        }, new StringBuilder().append((Object)"has parent path ").append((Object)Quote$.MODULE$.q((Object)parent)).toString(), new StringBuilder().append((Object)"doesn't have parent path ").append((Object)Quote$.MODULE$.q((Object)parent)).toString());
    }

    public static PathMatcher listPaths(PathBaseMatchers $this, Seq list) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this, list){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathBaseMatchers $outer;
            private final Seq list$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(String s) {
                if (this.list$1 == null) return false;
                List list = this.$outer.fileReader().listFiles(s).toList();
                List list2 = this.list$1.toList();
                if (list != null) {
                    if (!list.equals(list2)) return false;
                    return true;
                }
                if (list2 == null) return true;
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.list$1 = list$1;
            }
        }, new StringBuilder().append((Object)"has files ").append((Object)Quote$.MODULE$.q((Object)list.mkString(", "))).toString(), new StringBuilder().append((Object)"doesn't have files ").append((Object)Quote$.MODULE$.q((Object)list.toList().mkString(", "))).toString());
    }

    public static PathMatcher beEqualToIgnoringSep(PathBaseMatchers $this, String other) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this, other){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathBaseMatchers $outer;
            private final String other$1;

            public final boolean apply(String s) {
                return PathBaseMatchers$class.org$specs2$matcher$PathBaseMatchers$$isEqualIgnoringSep(this.$outer, this.$outer.fileReader().getCanonicalPath(s), this.other$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.other$1 = other$1;
            }
        }, new StringBuilder().append((Object)"is equal ignoring separators to ").append((Object)Quote$.MODULE$.q((Object)other)).toString(), new StringBuilder().append((Object)"is not equal ignoring separators to ").append((Object)Quote$.MODULE$.q((Object)other)).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean org$specs2$matcher$PathBaseMatchers$$isEqualIgnoringSep(PathBaseMatchers $this, String path, String other) {
        if (path == null) return false;
        if (other == null) return false;
        String string2 = $this.fileReader().getCanonicalPath(path).replaceAll("\\\\", "/");
        String string3 = $this.fileReader().getCanonicalPath(other).replaceAll("\\\\", "/");
        if (string2 != null) {
            if (!string2.equals(string3)) return false;
            return true;
        }
        if (string3 == null) return true;
        return false;
    }

    public static void $init$(PathBaseMatchers $this) {
        $this.org$specs2$matcher$PathBaseMatchers$_setter_$fileReader_$eq(new FileReader($this){

            public boolean exists(String path) {
                return FileReader.class.exists((FileReader)this, (String)path);
            }

            public boolean canRead(String path) {
                return FileReader.class.canRead((FileReader)this, (String)path);
            }

            public boolean canWrite(String path) {
                return FileReader.class.canWrite((FileReader)this, (String)path);
            }

            public boolean isAbsolute(String path) {
                return FileReader.class.isAbsolute((FileReader)this, (String)path);
            }

            public boolean isFile(String path) {
                return FileReader.class.isFile((FileReader)this, (String)path);
            }

            public boolean isDirectory(String path) {
                return FileReader.class.isDirectory((FileReader)this, (String)path);
            }

            public boolean isHidden(String path) {
                return FileReader.class.isHidden((FileReader)this, (String)path);
            }

            public String getName(String path) {
                return FileReader.class.getName((FileReader)this, (String)path);
            }

            public String getAbsolutePath(String path) {
                return FileReader.class.getAbsolutePath((FileReader)this, (String)path);
            }

            public String getCanonicalPath(String path) {
                return FileReader.class.getCanonicalPath((FileReader)this, (String)path);
            }

            public String getParent(String path) {
                return FileReader.class.getParent((FileReader)this, (String)path);
            }

            public List<String> listFiles(String path) {
                return FileReader.class.listFiles((FileReader)this, (String)path);
            }
            {
                FileReader.class.$init$((FileReader)this);
            }
        });
    }
}

