/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.test.lexer;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.test.lexer.MockHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.sslr.channel.CodeReader;

public final class TokenUtils {
    private TokenUtils() {
    }

    public static String merge(List<Token> tokens) {
        tokens = TokenUtils.removeLastTokenIfEof(tokens);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            result.append(token.getValue());
            if (i >= tokens.size() - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    private static List<Token> removeLastTokenIfEof(List<Token> tokens) {
        Token lastToken;
        if (!tokens.isEmpty() && "EOF".equals((lastToken = tokens.get(tokens.size() - 1)).getValue())) {
            return tokens.subList(0, tokens.size() - 1);
        }
        return tokens;
    }

    public static List<Token> lex(String sourceCode) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        CodeReader reader = new CodeReader(sourceCode);
        Matcher matcher = Pattern.compile("[a-zA-Z_0-9\\+\\-\\*/]+").matcher("");
        while (reader.peek() != -1) {
            Token token;
            StringBuilder nextStringToken = new StringBuilder();
            int linePosition = reader.getLinePosition();
            int columnPosition = reader.getColumnPosition();
            if (reader.popTo(matcher, (Appendable)nextStringToken) != -1) {
                token = "EOF".equals(nextStringToken.toString()) ? MockHelper.mockTokenBuilder((TokenType)GenericTokenType.EOF, nextStringToken.toString()).setLine(linePosition).setColumn(columnPosition).build() : MockHelper.mockTokenBuilder((TokenType)GenericTokenType.IDENTIFIER, nextStringToken.toString()).setLine(linePosition).setColumn(columnPosition).build();
            } else {
                if (Character.isWhitespace(reader.peek())) {
                    reader.pop();
                    continue;
                }
                token = MockHelper.mockTokenBuilder((TokenType)GenericTokenType.IDENTIFIER, Character.toString((char)reader.pop())).setLine(linePosition).setColumn(columnPosition).build();
            }
            tokens.add(token);
        }
        return tokens;
    }
}

