/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.nio.channels.SocketChannel;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.SocketFlusher;
import org.simpleframework.transport.TransportEvent;
import org.simpleframework.transport.reactor.Operation;
import org.simpleframework.transport.trace.Trace;

class FlushSignaller
implements Operation {
    private final SocketFlusher writer;
    private final Socket socket;
    private final Trace trace;

    public FlushSignaller(SocketFlusher writer, Socket socket) {
        this.trace = socket.getTrace();
        this.socket = socket;
        this.writer = writer;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public SocketChannel getChannel() {
        return this.socket.getChannel();
    }

    public void run() {
        try {
            this.writer.execute();
        }
        catch (Exception cause) {
            this.trace.trace((Object)TransportEvent.ERROR, cause);
            this.cancel();
        }
    }

    public void cancel() {
        try {
            this.writer.abort();
        }
        catch (Exception cause) {
            this.trace.trace((Object)TransportEvent.ERROR, cause);
        }
    }
}

