/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api;

import java.util.concurrent.TimeUnit;
import org.redisson.api.MapOptions;
import org.redisson.api.map.MapLoader;
import org.redisson.api.map.MapWriter;

public class LocalCachedMapOptions<K, V>
extends MapOptions<K, V> {
    private InvalidationPolicy invalidationPolicy;
    private EvictionPolicy evictionPolicy;
    private int cacheSize;
    private long timeToLiveInMillis;
    private long maxIdleInMillis;

    protected LocalCachedMapOptions() {
    }

    protected LocalCachedMapOptions(LocalCachedMapOptions<K, V> copy) {
        this.invalidationPolicy = copy.invalidationPolicy;
        this.evictionPolicy = copy.evictionPolicy;
        this.cacheSize = copy.cacheSize;
        this.timeToLiveInMillis = copy.timeToLiveInMillis;
        this.maxIdleInMillis = copy.maxIdleInMillis;
    }

    public static <K, V> LocalCachedMapOptions<K, V> defaults() {
        return new LocalCachedMapOptions<K, V>().cacheSize(0).timeToLive(0L).maxIdle(0L).evictionPolicy(EvictionPolicy.NONE).invalidationPolicy(InvalidationPolicy.ON_CHANGE);
    }

    public EvictionPolicy getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public long getTimeToLiveInMillis() {
        return this.timeToLiveInMillis;
    }

    public long getMaxIdleInMillis() {
        return this.maxIdleInMillis;
    }

    public LocalCachedMapOptions<K, V> cacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    public InvalidationPolicy getInvalidationPolicy() {
        return this.invalidationPolicy;
    }

    public LocalCachedMapOptions<K, V> invalidationPolicy(InvalidationPolicy invalidationPolicy) {
        this.invalidationPolicy = invalidationPolicy;
        return this;
    }

    @Deprecated
    public LocalCachedMapOptions<K, V> invalidateEntryOnChange(boolean value) {
        if (value) {
            return this.invalidationPolicy(InvalidationPolicy.ON_CHANGE);
        }
        return this.invalidationPolicy(InvalidationPolicy.NONE);
    }

    public LocalCachedMapOptions<K, V> evictionPolicy(EvictionPolicy evictionPolicy) {
        if (evictionPolicy == null) {
            throw new NullPointerException("evictionPolicy can't be null");
        }
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public LocalCachedMapOptions<K, V> timeToLive(long timeToLiveInMillis) {
        this.timeToLiveInMillis = timeToLiveInMillis;
        return this;
    }

    public LocalCachedMapOptions<K, V> timeToLive(long timeToLive, TimeUnit timeUnit) {
        return this.timeToLive(timeUnit.toMillis(timeToLive));
    }

    public LocalCachedMapOptions<K, V> maxIdle(long maxIdleInMillis) {
        this.maxIdleInMillis = maxIdleInMillis;
        return this;
    }

    public LocalCachedMapOptions<K, V> maxIdle(long maxIdle, TimeUnit timeUnit) {
        return this.maxIdle(timeUnit.toMillis(maxIdle));
    }

    @Override
    public LocalCachedMapOptions<K, V> writer(MapWriter<K, V> writer) {
        return (LocalCachedMapOptions)super.writer(writer);
    }

    @Override
    public LocalCachedMapOptions<K, V> writeBehindThreads(int writeBehindThreads) {
        return (LocalCachedMapOptions)super.writeBehindThreads(writeBehindThreads);
    }

    @Override
    public LocalCachedMapOptions<K, V> writeMode(MapOptions.WriteMode writeMode) {
        return (LocalCachedMapOptions)super.writeMode(writeMode);
    }

    @Override
    public LocalCachedMapOptions<K, V> loader(MapLoader<K, V> loader) {
        return (LocalCachedMapOptions)super.loader(loader);
    }

    public static enum EvictionPolicy {
        NONE,
        LRU,
        LFU,
        SOFT,
        WEAK;

    }

    public static enum InvalidationPolicy {
        NONE,
        ON_CHANGE,
        ON_CHANGE_WITH_CLEAR_ON_RECONNECT,
        ON_CHANGE_WITH_LOAD_ON_RECONNECT;

    }
}

