/*
 * Decompiled with CFR 0.152.
 */
package org.red5.classloading;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import org.red5.classloading.ChildFirstClassLoader;

public final class ClassLoaderBuilder {
    public static final int USE_CLASSPATH_LIB = 1;
    public static final int USE_RED5_LIB = 2;
    public static final int USE_WAR_LIB = 3;

    public static ClassLoader build() {
        return ClassLoaderBuilder.build(null, 2, null);
    }

    public static ClassLoader build(File path, int mode, ClassLoader parent) {
        JarFileFilter jarFileFilter = new JarFileFilter();
        ArrayList<URL> urlList = new ArrayList<URL>(31);
        URLClassLoader loader = null;
        URL[] urls = null;
        if (mode == 2) {
            File pluginsDir;
            File[] libFiles;
            File libDir;
            String home = System.getProperty("red5.root");
            if (home == null) {
                home = System.getenv("RED5_HOME");
            }
            if (home == null || ".".equals(home)) {
                String classLocation = ClassLoaderBuilder.class.getProtectionDomain().getCodeSource().getLocation().toString();
                home = classLocation.substring(0, classLocation.lastIndexOf(47));
            }
            try {
                File red5jar = new File(home, "red5-server.jar");
                if (!red5jar.exists()) {
                    System.out.println("Red5 server jar was not found, using fallback.");
                    red5jar = new File(home, "red5.jar");
                } else {
                    System.out.println("Red5 server jar was found");
                }
                urlList.add(red5jar.toURI().toURL());
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
            System.out.printf("URL list: %s\n", urlList);
            String libPath = System.getProperty("red5.lib_root");
            if (libPath == null) {
                libPath = home + "/lib";
            }
            if ((libDir = new File(libPath)) == null) {
                libDir = new File(home, "lib");
            }
            for (File lib : libFiles = libDir.listFiles(jarFileFilter)) {
                try {
                    urlList.add(lib.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    System.err.printf("Exception %s\n", e);
                }
            }
            ClassLoaderBuilder.scrubURLList(urlList);
            String conf = System.getProperty("red5.config_root");
            if (conf == null) {
                conf = home + "/conf";
            }
            try {
                URL confUrl = new File(conf).toURI().toURL();
                if (!urlList.contains(confUrl)) {
                    urlList.add(confUrl);
                }
            }
            catch (MalformedURLException e) {
                System.err.printf("Exception %s\n", e);
            }
            String pluginsPath = System.getProperty("red5.plugins_root");
            if (pluginsPath == null) {
                pluginsPath = home + "/plugins";
                System.setProperty("red5.plugins_root", pluginsPath);
            }
            if ((pluginsDir = new File(pluginsPath)) == null) {
                pluginsDir = new File(home, "plugins");
                pluginsDir.mkdirs();
            }
            try {
                URL pluginsUrl = pluginsDir.toURI().toURL();
                if (!urlList.contains(pluginsUrl)) {
                    urlList.add(pluginsUrl);
                }
            }
            catch (MalformedURLException e) {
                System.err.printf("Exception %s\n", e);
            }
            File[] pluginsFiles = pluginsDir.listFiles(jarFileFilter);
            if (pluginsFiles != null) {
                for (File file : pluginsFiles) {
                    try {
                        urlList.add(file.toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        System.err.printf("Exception %s\n", e);
                    }
                }
            }
            urls = urlList.toArray(new URL[0]);
            System.out.printf("Selected libraries: (%s items)\n", urls.length);
            for (Serializable serializable : urls) {
                System.out.println(serializable);
            }
            System.out.println();
            loader = parent == null ? new URLClassLoader(urls) : new URLClassLoader(urls, parent);
        } else {
            ArrayList<String> standardLibs = new ArrayList<String>(7);
            if (path != null) {
                try {
                    urlList.add(path.toURI().toURL());
                    URL classesURL = new URL("jar:file:" + path.getAbsolutePath().replace(File.separatorChar, '/') + "!/WEB-INF/classes/");
                    urlList.add(classesURL);
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
            }
            if (mode == 1) {
                String classPath = System.getProperty("java.class.path");
                StringTokenizer stClassPath = new StringTokenizer(classPath, File.pathSeparator);
                while (stClassPath.hasMoreTokens()) {
                    File[] nextPath = stClassPath.nextToken();
                    if (nextPath.toLowerCase().endsWith(".jar")) {
                        standardLibs.add(nextPath.substring(nextPath.lastIndexOf(File.separatorChar) + 1));
                    }
                    try {
                        urlList.add(new File((String)nextPath).toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        System.err.printf("Exception %s\n", e);
                    }
                }
            }
            if (mode == 3) {
                if (path.isDirectory()) {
                    File libDir = new File(path, "WEB-INF/lib");
                    if (libDir != null && libDir.canRead()) {
                        File[] libs;
                        for (File lib : libs = libDir.listFiles(jarFileFilter)) {
                            try {
                                urlList.add(lib.toURI().toURL());
                            }
                            catch (MalformedURLException e) {
                                System.err.printf("Exception %s\n", e);
                            }
                        }
                    }
                } else {
                    try {
                        JarInputStream jarStream = new JarInputStream(new FileInputStream(path));
                        JarEntry entry = jarStream.getNextJarEntry();
                        while (entry != null) {
                            String entryName = entry.getName();
                            if (entryName.startsWith("WEB-INF/lib/") && entryName.endsWith(".jar") && !standardLibs.contains(entryName.substring(12))) {
                                File tempJarFile = ClassLoaderBuilder.unpack(jarStream, entryName);
                                urlList.add(tempJarFile.toURI().toURL());
                            }
                            entry = jarStream.getNextJarEntry();
                        }
                        jarStream.close();
                    }
                    catch (IOException e) {
                        System.err.printf("Exception %s\n", e);
                    }
                }
            }
            urls = urlList.toArray(new URL[0]);
            loader = new ChildFirstClassLoader(urls, parent);
        }
        Thread.currentThread().setContextClassLoader(loader);
        return loader;
    }

    private static File unpack(JarInputStream jarStream, String entryName) throws IOException {
        int len;
        String libName = entryName.substring(entryName.lastIndexOf(47) + 1, entryName.length() - 4);
        File tempJarFile = File.createTempFile("tmp_" + libName, ".jar");
        tempJarFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(tempJarFile);
        byte[] buf = new byte[8192];
        while ((len = jarStream.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.close();
        return tempJarFile;
    }

    private static final void scrubURLList(List<URL> list) {
        URL[] urls;
        String ALPHABET = "abcdefghijklmnopqrstuvwxyz";
        Pattern punct = Pattern.compile("\\p{Punct}");
        HashSet<URL> removalList = new HashSet<URL>(list.size());
        String topName = null;
        String checkName = null;
        block4: for (URL top : urls = list.toArray(new URL[0])) {
            if (removalList.contains(top)) continue;
            topName = ClassLoaderBuilder.parseUrl(top);
            if ("".equals(topName)) {
                removalList.add(top);
                continue;
            }
            if (topName.startsWith("red5")) continue;
            if (topName.endsWith("-")) {
                removalList.add(top);
                continue;
            }
            if (topName.startsWith("grobo") || topName.startsWith("junit") || topName.startsWith("ivy")) {
                removalList.add(top);
                continue;
            }
            if (topName.contains("javadoc") || topName.contains("sources")) {
                removalList.add(top);
                continue;
            }
            int topFirstDash = topName.indexOf(45);
            String prefix = topName.substring(0, topFirstDash != -1 ? topFirstDash : 3);
            int topSecondDash = topName.indexOf(45, topFirstDash + 1);
            for (URL check : list) {
                int checkVersionNumber;
                int topVersionNumber;
                String[] topVersion;
                String checkVers;
                String[] checkSubs;
                String[] topSubs;
                if (removalList.contains(check) || (checkName = ClassLoaderBuilder.parseUrl(check)).equals(topName) || checkName.endsWith("-") || !checkName.startsWith(prefix) || topSecondDash > 0 && (checkName.length() <= topSecondDash || checkName.charAt(topSecondDash) != '-' || !(topSubs = topName.split("-"))[1].equals((checkSubs = checkName.split("-"))[1]) || !Character.isDigit(topSubs[2].charAt(0)) && !Character.isDigit(checkSubs[2].charAt(0)) && !topSubs[2].equals(checkSubs[2])) || checkName.length() < topFirstDash + 1 || (checkVers = checkName.substring(topSecondDash != -1 ? topSecondDash + 1 : topFirstDash + 1)).startsWith("-")) continue;
                String topVers = topName.substring(topSecondDash != -1 ? topSecondDash + 1 : topFirstDash + 1);
                int topThirdDash = -1;
                String topThirdName = null;
                if (topVers.length() > 0 && !Character.isDigit(topVers.charAt(0))) {
                    topThirdDash = topVers.indexOf(45);
                    if (topThirdDash == -1) continue;
                    topThirdName = topVers.substring(0, topThirdDash);
                    topVers = topVers.substring(topThirdDash + 1);
                }
                int checkThirdDash = -1;
                String checkThirdName = null;
                if (!Character.isDigit(checkVers.charAt(0))) {
                    checkThirdDash = checkVers.indexOf(45);
                    if (checkThirdDash == -1) continue;
                    checkThirdName = checkVers.substring(0, checkThirdDash);
                    if (topThirdName == null || !topThirdName.equals(checkThirdName) || !Character.isDigit((checkVers = checkVers.substring(checkThirdDash + 1)).charAt(0))) continue;
                }
                if (topThirdName != null && checkThirdName == null || !(topVersion = punct.split(topVers))[0].matches("[\\d].*")) continue;
                if (topVersion.length > 2) {
                    char ch;
                    String v = topVersion[2].toLowerCase();
                    if (v.length() > 1) {
                        topVersion[2] = ClassLoaderBuilder.deleteAny(v, ALPHABET);
                    }
                    if (topVersion[2].length() == 1 && !Character.isDigit(ch = v.charAt(0))) {
                        topVersion[2] = ALPHABET.indexOf(ch) + "";
                    }
                }
                try {
                    topVersionNumber = topVersion.length == 1 ? Integer.valueOf(topVersion[0]).intValue() : Integer.valueOf(topVersion[0] + topVersion[1] + (topVersion.length > 2 ? topVersion[2] : Character.valueOf('0'))).intValue();
                }
                catch (NumberFormatException nfe) {
                    topVersionNumber = 0;
                    System.err.println("Error parsing topVers:" + topVers);
                }
                String[] checkVersion = punct.split(checkVers);
                if (checkVersion.length > 2) {
                    char ch;
                    String v = checkVersion[2].toLowerCase();
                    if (v.length() > 1) {
                        checkVersion[2] = ClassLoaderBuilder.deleteAny(v, ALPHABET);
                    }
                    if (checkVersion[2].length() == 1 && !Character.isDigit(ch = v.charAt(0))) {
                        checkVersion[2] = ALPHABET.indexOf(ch) + "";
                    }
                }
                try {
                    checkVersionNumber = checkVersion.length == 1 ? Integer.valueOf(checkVersion[0]).intValue() : Integer.valueOf(checkVersion[0] + checkVersion[1] + (checkVersion.length > 2 ? checkVersion[2] : Character.valueOf('0'))).intValue();
                }
                catch (NumberFormatException nfe) {
                    checkVersionNumber = 0;
                    System.err.println("Error parsing checkVers:" + checkVers);
                }
                if (topVersionNumber >= checkVersionNumber) {
                    removalList.add(check);
                    continue;
                }
                removalList.add(top);
                continue block4;
            }
        }
        list.removeAll(removalList);
    }

    private static String parseUrl(URL url) {
        String external = url.toExternalForm().toLowerCase();
        String[] parts = external.split("/");
        String libName = parts[parts.length - 1];
        libName = libName.substring(0, libName.length() - 4);
        return libName;
    }

    private static String deleteAny(String str, String removalChars) {
        String[] chars;
        StringBuilder sb = new StringBuilder(str);
        for (String c : chars = removalChars.split("")) {
            int index = -1;
            while ((index = sb.indexOf(c)) > 0) {
                sb.deleteCharAt(index);
            }
        }
        return sb.toString();
    }

    public static final class JarFileFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

