/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.junit.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.JUnit4ConfigMethod;
import org.ops4j.pax.exam.junit.RequiresConfiguration;
import org.ops4j.pax.exam.options.CompositeOption;

public class DefaultConfigMethod
implements JUnit4ConfigMethod {
    private final Method m_method;
    private final Object m_configInstance;
    private Option[] m_options;

    public DefaultConfigMethod(Method configMethod, Object configInstance) {
        NullArgumentException.validateNotNull((Object)configMethod, (String)"Configuration method");
        this.m_method = configMethod;
        this.m_configInstance = configInstance;
    }

    public boolean matches(Method method) {
        NullArgumentException.validateNotNull((Object)method, (String)"Method");
        RequiresConfiguration requiresConfigAnnotation = method.getAnnotation(RequiresConfiguration.class);
        String[] requiredConfigs = requiresConfigAnnotation != null ? requiresConfigAnnotation.value() : new String[]{".*"};
        for (String requiredConfig : requiredConfigs) {
            if (!this.m_method.getName().matches(requiredConfig)) continue;
            return true;
        }
        return false;
    }

    public Option[] getOptions() throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (this.m_options == null) {
            ArrayList<Object> options = new ArrayList<Object>();
            Configuration config = this.m_method.getAnnotation(Configuration.class);
            for (Class<? extends CompositeOption> clazz : config.extend()) {
                for (Option o : clazz.newInstance().getOptions()) {
                    options.add(o);
                }
            }
            for (Class<? extends CompositeOption> clazz : (Option[])this.m_method.invoke(this.m_configInstance, new Object[0])) {
                options.add(clazz);
            }
            this.m_options = options.toArray(new Option[options.size()]);
        }
        return this.m_options;
    }
}

