/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.invoker.junit.internal;

import java.lang.reflect.Method;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.ops4j.pax.exam.ProbeInvoker;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.invoker.junit.internal.ContainerTestRunnerClassRequest;
import org.ops4j.pax.exam.util.Injector;
import org.ops4j.pax.swissbox.tracker.ServiceLookup;
import org.osgi.framework.BundleContext;

public class JUnitProbeInvoker
implements ProbeInvoker {
    private BundleContext ctx;
    private String clazz;
    private String method;
    private Injector injector;

    public JUnitProbeInvoker(String encodedInstruction, BundleContext bundleContext) {
        String[] parts = encodedInstruction.split(";");
        this.clazz = parts[0];
        this.method = parts[1];
        this.ctx = bundleContext;
        this.injector = (Injector)ServiceLookup.getService((BundleContext)this.ctx, Injector.class);
    }

    public void call(Object ... args) {
        Class testClass;
        try {
            testClass = this.ctx.getBundle().loadClass(this.clazz);
        }
        catch (ClassNotFoundException e) {
            throw new TestContainerException((Throwable)e);
        }
        if (!this.findAndInvoke(testClass)) {
            throw new TestContainerException(" Test " + this.method + " not found in test class " + testClass.getName());
        }
    }

    private boolean findAndInvoke(Class<?> testClass) {
        try {
            for (Method m : testClass.getMethods()) {
                if (!m.getName().equals(this.method)) continue;
                this.invokeViaJUnit(testClass, m);
                return true;
            }
        }
        catch (NoClassDefFoundError e) {
            throw new TestContainerException((Throwable)e);
        }
        return false;
    }

    private void invokeViaJUnit(Class<?> testClass, Method testMethod) {
        JUnitCore junit = new JUnitCore();
        ContainerTestRunnerClassRequest classRequest = new ContainerTestRunnerClassRequest(testClass, this.injector);
        Description methodDescription = Description.createTestDescription(testClass, (String)this.method);
        Request request = classRequest.filterWith(methodDescription);
        Result result = junit.run(request);
        List failures = result.getFailures();
        if (!failures.isEmpty()) {
            throw new TestContainerException(failures.toString(), ((Failure)failures.get(0)).getException());
        }
    }
}

