/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sail.query;

import java.io.IOException;
import java.util.Collection;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.query.DuplicatesFilter;
import org.openrdf.sesame.sail.query.GraphPattern;
import org.openrdf.sesame.sail.query.OffsetFilter;
import org.openrdf.sesame.sail.query.Query;
import org.openrdf.sesame.sail.query.QueryAnswerListener;
import org.openrdf.sesame.sail.query.QueryResultsCounter;
import org.openrdf.sesame.sail.query.SailQueryException;

public abstract class GraphPatternQuery
implements Query {
    private boolean _distinct;
    private int _offset;
    private int _limit;
    private GraphPattern _graphPattern;

    protected GraphPatternQuery(GraphPattern graphPattern) {
        this(false, graphPattern);
    }

    protected GraphPatternQuery(boolean distinct, GraphPattern graphPattern) {
        this(distinct, 0, Integer.MAX_VALUE, graphPattern);
    }

    protected GraphPatternQuery(boolean distinct, int offset, int limit, GraphPattern graphPattern) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset must be non-negative, is: " + offset);
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit must be non-negative, is: " + limit);
        }
        this._distinct = distinct;
        this._offset = offset;
        this._limit = limit;
        this._graphPattern = graphPattern;
    }

    public boolean isDistinct() {
        return this._distinct;
    }

    public void setDistinct(boolean distinct) {
        this._distinct = distinct;
    }

    public int getOffset() {
        return this._offset;
    }

    public boolean hasOffset() {
        return this._offset > 0;
    }

    public void setOffset(int offset) {
        this._offset = offset;
    }

    public int getLimit() {
        return this._limit;
    }

    public boolean hasLimit() {
        return this._limit < Integer.MAX_VALUE;
    }

    public void setLimit(int limit) {
        this._limit = limit;
    }

    public void setGraphPattern(GraphPattern graphPattern) {
        this._graphPattern = graphPattern;
    }

    public GraphPattern getGraphPattern() {
        return this._graphPattern;
    }

    public void getVariables(Collection variables) {
        this._graphPattern.getVariables(variables);
    }

    public abstract void getProjectionVariables(Collection var1);

    public void evaluate(RdfSource rdfSource, QueryAnswerListener listener) throws SailQueryException {
        if (this._limit <= 0) {
            return;
        }
        QueryResultsCounter countListener = null;
        if (this._limit < Integer.MAX_VALUE) {
            countListener = new QueryResultsCounter(listener);
            listener = countListener;
        }
        if (this._offset > 0) {
            listener = new OffsetFilter(listener, this._offset);
        }
        if (this._distinct) {
            listener = new DuplicatesFilter(listener);
        }
        this._graphPattern.initialize(rdfSource);
        try {
            boolean instantiated = this._graphPattern.findFirst(rdfSource);
            while (instantiated) {
                boolean continueEvaluation = this._reportQueryAnswer(rdfSource, listener);
                if (!continueEvaluation) {
                    break;
                }
                if (countListener == null || countListener.getCount() < this._limit) {
                    instantiated = this._graphPattern.findNext(rdfSource);
                    continue;
                }
                instantiated = false;
            }
        }
        catch (IOException e) {
            throw new SailQueryException(e);
        }
        finally {
            this._graphPattern.clear();
        }
    }

    protected abstract boolean _reportQueryAnswer(RdfSource var1, QueryAnswerListener var2) throws IOException;
}

