/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.string;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import org.apache.commons.lang3.StringUtils;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;

public class NDArrayStrings {
    private String sep = ",";
    private int padding = 0;
    private String decFormatNum = "#,###,##0";
    private String decFormatRest = "";
    private DecimalFormat decimalFormat = new DecimalFormat(this.decFormatNum + this.decFormatRest);

    public NDArrayStrings() {
        this(true);
    }

    public NDArrayStrings(String sep) {
        this(sep, true);
    }

    public NDArrayStrings(String sep, boolean commas) {
        this(", ", 2, "#,###,##0", commas);
    }

    public NDArrayStrings(int precision) {
        this(precision, true);
    }

    public NDArrayStrings(int precision, boolean commas) {
        this(", ", precision, "#,###,##0", commas);
    }

    public NDArrayStrings(String sep, int precision) {
        this(sep, precision, true);
    }

    public NDArrayStrings(String sep, int precision, boolean commas) {
        this(sep, precision, "#,###,##0", commas);
    }

    public NDArrayStrings(String sep, int precision, String decFormat) {
        this(sep, precision, decFormat, true);
    }

    public NDArrayStrings(String sep, int precision, String decFormat, boolean commas) {
        this.decFormatNum = decFormat;
        this.sep = sep;
        if (precision != 0) {
            this.decFormatRest = ".";
            while (precision > 0) {
                this.decFormatRest = this.decFormatRest + "0";
                --precision;
            }
        }
        this.decimalFormat = new DecimalFormat(this.decFormatNum + this.decFormatRest);
        DecimalFormatSymbols sepNgroup = DecimalFormatSymbols.getInstance();
        sepNgroup.setDecimalSeparator('.');
        if (!commas) {
            NumberFormat format = NumberFormat.getIntegerInstance();
            format.setGroupingUsed(false);
        }
        sepNgroup.setGroupingSeparator(',');
        this.decimalFormat.setDecimalFormatSymbols(sepNgroup);
    }

    public NDArrayStrings(boolean commas) {
        this(", ", 2, "#,###,##0", commas);
    }

    public String format(INDArray arr) {
        String padding = this.decimalFormat.format(3.0);
        this.padding = padding.length();
        return this.format(arr, arr.rank());
    }

    private String format(INDArray arr, int rank) {
        return this.format(arr, arr.rank(), 0);
    }

    private String format(INDArray arr, int rank, int offset) {
        StringBuilder sb = new StringBuilder();
        if (arr.isScalar()) {
            if (arr instanceof IComplexNDArray) {
                return ((IComplexNDArray)arr).getComplex(0).toString();
            }
            return this.decimalFormat.format(arr.getDouble(0));
        }
        if (rank <= 0) {
            return "";
        }
        if (arr.isVector()) {
            sb.append("[");
            for (int i = 0; i < arr.length(); ++i) {
                if (arr instanceof IComplexNDArray) {
                    sb.append(((IComplexNDArray)arr).getComplex(i).toString());
                } else {
                    sb.append(String.format("%1$" + this.padding + "s", this.decimalFormat.format(arr.getDouble(i))));
                }
                if (i >= arr.length() - 1) continue;
                sb.append(this.sep);
                sb.append(" ");
            }
            sb.append("]");
            return sb.toString();
        }
        ++offset;
        sb.append("[");
        for (int i = 0; i < arr.slices(); ++i) {
            sb.append(this.format(arr.slice(i), rank - 1, offset));
            if (i == arr.slices() - 1) continue;
            sb.append(this.sep + " \n");
            sb.append(StringUtils.repeat((String)"\n", (int)(rank - 2)));
            sb.append(StringUtils.repeat((String)" ", (int)offset));
        }
        sb.append("]");
        return sb.toString();
    }
}

