/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning.config;

import java.beans.ConstructorProperties;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.SgdUpdater;
import org.nd4j.linalg.learning.config.IUpdater;

public class Sgd
implements IUpdater {
    public static final double DEFAULT_SGD_LR = 0.001;
    private double learningRate;

    public Sgd() {
        this(0.001);
    }

    @Override
    public long stateSize(long numParams) {
        return 0L;
    }

    @Override
    public void applySchedules(int iteration, double newLearningRate) {
        this.learningRate = newLearningRate;
    }

    @Override
    public GradientUpdater instantiate(INDArray viewArray, boolean initializeViewArray) {
        if (viewArray != null) {
            throw new IllegalStateException("View arrays are not supported/required for SGD updater");
        }
        return new SgdUpdater(this);
    }

    @Override
    public Sgd clone() {
        return new Sgd(this.learningRate);
    }

    public static Builder builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"learningRate"})
    public Sgd(double learningRate) {
        this.learningRate = learningRate;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public String toString() {
        return "Sgd(learningRate=" + this.getLearningRate() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sgd)) {
            return false;
        }
        Sgd other = (Sgd)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getLearningRate(), other.getLearningRate()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Sgd;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        return result;
    }

    public static class Builder {
        private double learningRate = 0.001;

        public Builder learningRate(double learningRate) {
            this.learningRate = learningRate;
            return this;
        }

        public Sgd build() {
            return new Sgd(this.learningRate);
        }

        public String toString() {
            return "Sgd.Builder(learningRate=" + this.learningRate + ")";
        }
    }
}

