/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import com.google.common.primitives.Longs;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.INDArrayIndex;

public class PointIndex
implements INDArrayIndex {
    private long point;
    private boolean notUsed = true;

    public PointIndex(int point) {
        this.point = point;
    }

    @Override
    public long end() {
        return this.point;
    }

    @Override
    public long offset() {
        return this.point;
    }

    @Override
    public long length() {
        return 1L;
    }

    @Override
    public long stride() {
        return 1L;
    }

    @Override
    public long current() {
        return this.point;
    }

    @Override
    public boolean hasNext() {
        return this.notUsed;
    }

    @Override
    public long next() {
        long ret = this.point;
        this.notUsed = false;
        return ret;
    }

    @Override
    public void reverse() {
    }

    @Override
    public boolean isInterval() {
        return false;
    }

    @Override
    public void setInterval(boolean isInterval) {
    }

    @Override
    public void init(INDArray arr, long begin, int dimension) {
    }

    @Override
    public void init(INDArray arr, int dimension) {
    }

    @Override
    public void init(long begin, long end) {
    }

    @Override
    public void reset() {
        this.notUsed = false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PointIndex)) {
            return false;
        }
        PointIndex that = (PointIndex)o;
        if (this.point != that.point) {
            return false;
        }
        return this.notUsed == that.notUsed;
    }

    public int hashCode() {
        int result = Longs.hashCode((long)this.point);
        result = 31 * result + (this.notUsed ? 1 : 0);
        return result;
    }
}

