/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.preprocessor.serializer;

import java.beans.ConstructorProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.nd4j.linalg.dataset.api.preprocessor.Normalizer;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.CustomSerializerStrategy;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.MinMaxSerializerStrategy;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.MultiHybridSerializerStrategy;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.MultiMinMaxSerializerStrategy;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.MultiStandardizeSerializerStrategy;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.NormalizerSerializerStrategy;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.NormalizerType;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.StandardizeSerializerStrategy;

public class NormalizerSerializer {
    private static final String HEADER = "NORMALIZER";
    private static NormalizerSerializer defaultSerializer;
    private List<NormalizerSerializerStrategy> strategies = new ArrayList<NormalizerSerializerStrategy>();

    public void write(@NonNull Normalizer normalizer, @NonNull File file) throws IOException {
        if (normalizer == null) {
            throw new NullPointerException("normalizer");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            this.write(normalizer, out);
        }
    }

    public void write(@NonNull Normalizer normalizer, @NonNull String path) throws IOException {
        if (normalizer == null) {
            throw new NullPointerException("normalizer");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(path));){
            this.write(normalizer, out);
        }
    }

    public void write(@NonNull Normalizer normalizer, @NonNull OutputStream stream) throws IOException {
        if (normalizer == null) {
            throw new NullPointerException("normalizer");
        }
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        NormalizerSerializerStrategy strategy = this.getStrategy(normalizer);
        this.writeHeader(stream, Header.fromStrategy(strategy));
        strategy.write(normalizer, stream);
    }

    public <T extends Normalizer> T restore(@NonNull String path) throws Exception {
        if (path == null) {
            throw new NullPointerException("path");
        }
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(path));){
            T t = this.restore(in);
            return t;
        }
    }

    public <T extends Normalizer> T restore(@NonNull File file) throws Exception {
        if (file == null) {
            throw new NullPointerException("file");
        }
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            T t = this.restore(in);
            return t;
        }
    }

    public <T extends Normalizer> T restore(@NonNull InputStream stream) throws Exception {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        Header header = this.parseHeader(stream);
        return this.getStrategy(header).restore(stream);
    }

    public static NormalizerSerializer getDefault() {
        if (defaultSerializer == null) {
            defaultSerializer = new NormalizerSerializer().addStrategy(new StandardizeSerializerStrategy()).addStrategy(new MinMaxSerializerStrategy()).addStrategy(new MultiStandardizeSerializerStrategy()).addStrategy(new MultiMinMaxSerializerStrategy()).addStrategy(new MultiHybridSerializerStrategy());
        }
        return defaultSerializer;
    }

    public NormalizerSerializer addStrategy(@NonNull NormalizerSerializerStrategy strategy) {
        if (strategy == null) {
            throw new NullPointerException("strategy");
        }
        this.strategies.add(strategy);
        return this;
    }

    private NormalizerSerializerStrategy getStrategy(Normalizer normalizer) {
        for (NormalizerSerializerStrategy strategy : this.strategies) {
            if (!this.strategySupportsNormalizer(strategy, normalizer.getType(), normalizer.getClass())) continue;
            return strategy;
        }
        throw new RuntimeException(String.format("No serializer strategy found for normalizer of class %s. If this is a custom normalizer, you probably forgot to register a corresponding custom serializer strategy with this serializer.", normalizer.getClass()));
    }

    private NormalizerSerializerStrategy getStrategy(Header header) throws Exception {
        if (header.normalizerType.equals((Object)NormalizerType.CUSTOM)) {
            return (NormalizerSerializerStrategy)header.customStrategyClass.newInstance();
        }
        for (NormalizerSerializerStrategy strategy : this.strategies) {
            if (!this.strategySupportsNormalizer(strategy, header.normalizerType, null)) continue;
            return strategy;
        }
        throw new RuntimeException("No serializer strategy found for given header " + header);
    }

    private boolean strategySupportsNormalizer(NormalizerSerializerStrategy strategy, NormalizerType normalizerType, Class<? extends Normalizer> normalizerClass) {
        if (!strategy.getSupportedType().equals((Object)normalizerType)) {
            return false;
        }
        if (strategy.getSupportedType().equals((Object)NormalizerType.CUSTOM)) {
            if (!(strategy instanceof CustomSerializerStrategy)) {
                throw new IllegalArgumentException("Strategies supporting CUSTOM type must be instance of CustomSerializerStrategy, got" + strategy.getClass());
            }
            return ((CustomSerializerStrategy)strategy).getSupportedClass().equals(normalizerClass);
        }
        return true;
    }

    private Header parseHeader(InputStream stream) throws IOException, ClassNotFoundException {
        DataInputStream dis = new DataInputStream(stream);
        String header = dis.readUTF();
        if (!header.equals(HEADER)) {
            throw new IllegalArgumentException("Could not restore normalizer: invalid header. If this normalizer was saved with a type-specific strategy like StandardizeSerializerStrategy, use that class to restore it as well.");
        }
        int version = dis.readInt();
        if (version != 1) {
            throw new IllegalArgumentException("Could not restore normalizer: invalid version (" + version + ")");
        }
        NormalizerType type = NormalizerType.valueOf(dis.readUTF());
        if (type.equals((Object)NormalizerType.CUSTOM)) {
            String strategyClassName = dis.readUTF();
            return new Header(type, Class.forName(strategyClassName));
        }
        return new Header(type, null);
    }

    private void writeHeader(OutputStream stream, Header header) throws IOException {
        DataOutputStream dos = new DataOutputStream(stream);
        dos.writeUTF(HEADER);
        dos.writeInt(1);
        dos.writeUTF(header.normalizerType.toString());
        if (header.customStrategyClass != null) {
            dos.writeUTF(header.customStrategyClass.getName());
        }
    }

    private static final class Header {
        private final NormalizerType normalizerType;
        private final Class<? extends NormalizerSerializerStrategy> customStrategyClass;

        public static Header fromStrategy(NormalizerSerializerStrategy strategy) {
            if (strategy instanceof CustomSerializerStrategy) {
                return new Header(strategy.getSupportedType(), strategy.getClass());
            }
            return new Header(strategy.getSupportedType(), null);
        }

        @ConstructorProperties(value={"normalizerType", "customStrategyClass"})
        public Header(NormalizerType normalizerType, Class<? extends NormalizerSerializerStrategy> customStrategyClass) {
            this.normalizerType = normalizerType;
            this.customStrategyClass = customStrategyClass;
        }

        public NormalizerType getNormalizerType() {
            return this.normalizerType;
        }

        public Class<? extends NormalizerSerializerStrategy> getCustomStrategyClass() {
            return this.customStrategyClass;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Header)) {
                return false;
            }
            Header other = (Header)o;
            NormalizerType this$normalizerType = this.getNormalizerType();
            NormalizerType other$normalizerType = other.getNormalizerType();
            if (this$normalizerType == null ? other$normalizerType != null : !((Object)((Object)this$normalizerType)).equals((Object)other$normalizerType)) {
                return false;
            }
            Class<? extends NormalizerSerializerStrategy> this$customStrategyClass = this.getCustomStrategyClass();
            Class<? extends NormalizerSerializerStrategy> other$customStrategyClass = other.getCustomStrategyClass();
            return !(this$customStrategyClass == null ? other$customStrategyClass != null : !this$customStrategyClass.equals(other$customStrategyClass));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            NormalizerType $normalizerType = this.getNormalizerType();
            result = result * 59 + ($normalizerType == null ? 43 : ((Object)((Object)$normalizerType)).hashCode());
            Class<? extends NormalizerSerializerStrategy> $customStrategyClass = this.getCustomStrategyClass();
            result = result * 59 + ($customStrategyClass == null ? 43 : $customStrategyClass.hashCode());
            return result;
        }

        public String toString() {
            return "NormalizerSerializer.Header(normalizerType=" + (Object)((Object)this.getNormalizerType()) + ", customStrategyClass=" + this.getCustomStrategyClass() + ")";
        }
    }
}

