/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.convolution;

import java.util.Arrays;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.convolution.BaseConvolution;
import org.nd4j.linalg.convolution.Convolution;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.fft.FFT;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.util.ComplexNDArrayUtil;
import org.nd4j.linalg.util.NDArrayUtil;

public class DefaultConvolutionInstance
extends BaseConvolution {
    @Override
    public IComplexNDArray convn(IComplexNDArray input, IComplexNDArray kernel, Convolution.Type type, int[] axes) {
        if (kernel.isScalar() && input.isScalar()) {
            return kernel.mul(input);
        }
        INDArray shape = NDArrayUtil.toNDArray(Shape.sizeForAxes(axes, input.shape())).add(NDArrayUtil.toNDArray(Shape.sizeForAxes(axes, kernel.shape()))).subi(1);
        int[] intShape = NDArrayUtil.toInts(shape);
        IComplexNDArray ret = FFT.rawifftn(FFT.rawfftn(input, intShape, axes).muli(FFT.rawfftn(kernel, intShape, axes)), intShape, axes);
        switch (type) {
            case FULL: {
                return ret;
            }
            case SAME: {
                return ComplexNDArrayUtil.center(ret, input.shape());
            }
            case VALID: {
                return ComplexNDArrayUtil.center(ret, NDArrayUtil.toInts(Transforms.abs(NDArrayUtil.toNDArray(input.shape()).sub(NDArrayUtil.toNDArray(kernel.shape())).addi(1))));
            }
        }
        return ret;
    }

    @Override
    public INDArray convn(INDArray input, INDArray kernel, Convolution.Type type, int[] axes) {
        if (input.shape().length != kernel.shape().length) {
            int i;
            int[] newShape = new int[Math.max(input.shape().length, kernel.shape().length)];
            Arrays.fill(newShape, 1);
            int lengthDelta = Math.abs(input.shape().length - kernel.shape().length);
            if (input.shape().length < kernel.shape().length) {
                for (i = input.shape().length - 1; i >= 0; --i) {
                    newShape[i + lengthDelta] = input.shape()[i];
                }
                input = input.reshape(newShape);
            } else if (kernel.shape().length < input.shape().length) {
                for (i = kernel.shape().length - 1; i >= 0; --i) {
                    newShape[i + lengthDelta] = kernel.shape()[i];
                }
                kernel = kernel.reshape(newShape);
            }
        }
        if (kernel.isScalar() && input.isScalar()) {
            return kernel.mul(input);
        }
        INDArray shape = NDArrayUtil.toNDArray(input.shape()).add(NDArrayUtil.toNDArray(kernel.shape())).subi(1);
        int[] intShape = NDArrayUtil.toInts(shape);
        IComplexNDArray fftedInput = FFT.rawfftn(Nd4j.createComplex(input), intShape, axes);
        IComplexNDArray fftedKernel = FFT.rawfftn(Nd4j.createComplex(kernel), intShape, axes);
        if (!Arrays.equals(fftedInput.shape(), fftedKernel.shape())) {
            if (fftedInput.length() < fftedKernel.length()) {
                fftedInput = ComplexNDArrayUtil.padWithZeros(fftedInput, fftedKernel.shape());
            } else {
                fftedKernel = ComplexNDArrayUtil.padWithZeros(fftedKernel, fftedInput.shape());
            }
        }
        IComplexNDArray inputTimesKernel = fftedInput.muli(fftedKernel);
        IComplexNDArray convolution = FFT.ifftn(inputTimesKernel);
        switch (type) {
            case FULL: {
                return convolution.getReal();
            }
            case SAME: {
                return ComplexNDArrayUtil.center(convolution, input.shape()).getReal();
            }
            case VALID: {
                int[] shape2 = NDArrayUtil.toInts(Transforms.abs(NDArrayUtil.toNDArray(input.shape()).sub(NDArrayUtil.toNDArray(kernel.shape())).addi(1)));
                return ComplexNDArrayUtil.center(convolution, shape2).getReal();
            }
        }
        return convolution.getReal();
    }
}

