/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class LeakyReLUDerivative
extends BaseTransformOp {
    private double alpha = 0.01;

    public LeakyReLUDerivative() {
    }

    public LeakyReLUDerivative(INDArray x, INDArray z) {
        super(x, z);
    }

    public LeakyReLUDerivative(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public LeakyReLUDerivative(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public LeakyReLUDerivative(INDArray x) {
        super(x);
    }

    public LeakyReLUDerivative(INDArray x, INDArray z, double alpha) {
        super(x, z);
        this.alpha = alpha;
        this.init(x, this.y, z, this.n);
    }

    public LeakyReLUDerivative(INDArray x, INDArray z, long n, double alpha) {
        super(x, z, n);
        this.alpha = alpha;
        this.init(x, this.y, z, n);
    }

    public LeakyReLUDerivative(INDArray x, INDArray y, INDArray z, long n, double alpha) {
        super(x, y, z, n);
        this.alpha = alpha;
        this.init(x, y, z, n);
    }

    public LeakyReLUDerivative(INDArray x, double alpha) {
        super(x);
        this.alpha = alpha;
        this.init(x, this.y, this.z, this.n);
    }

    @Override
    public int opNum() {
        return 32;
    }

    @Override
    public String name() {
        return "leakyreluderivative";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return origin.realComponent().doubleValue() >= 0.0 ? Nd4j.createDouble(1.0, 0.0) : Nd4j.createDouble(this.alpha, 0.0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return origin.realComponent().doubleValue() >= 0.0 ? Nd4j.createDouble(1.0, 0.0) : Nd4j.createDouble(this.alpha, 0.0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return origin.realComponent().doubleValue() >= 0.0 ? Nd4j.createDouble(1.0, 0.0) : Nd4j.createDouble(this.alpha, 0.0);
    }

    @Override
    public float op(float origin, float other) {
        return origin >= 0.0f ? 1.0f : (float)this.alpha;
    }

    @Override
    public double op(double origin, double other) {
        return origin >= 0.0 ? 1.0 : this.alpha;
    }

    @Override
    public double op(double origin) {
        return origin >= 0.0 ? 1.0 : this.alpha;
    }

    @Override
    public float op(float origin) {
        return origin >= 0.0f ? 1.0f : (float)this.alpha;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return origin.realComponent().doubleValue() >= 0.0 ? Nd4j.createDouble(1.0, 0.0) : Nd4j.createDouble(this.alpha, 0.0);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new LeakyReLUDerivative(this.x.vectorAlongDimension(index, dimension), this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length(), this.alpha);
        }
        return new LeakyReLUDerivative(this.x.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length(), this.alpha);
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new LeakyReLUDerivative(this.x.tensorAlongDimension(index, dimension), this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length(), this.alpha);
        }
        return new LeakyReLUDerivative(this.x.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length(), this.alpha);
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, long n) {
        super.init(x, y, z, n);
        this.extraArgs = new Object[]{this.alpha};
    }
}

