/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.indexaccum;

import lombok.NonNull;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseIndexAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.conditions.Condition;

public class FirstIndex
extends BaseIndexAccumulation {
    protected Condition condition;
    protected double compare;
    protected double eps;
    protected int mode;

    public FirstIndex() {
    }

    public FirstIndex(INDArray x, @NonNull Condition condition) {
        this(x, condition, Nd4j.EPS_THRESHOLD);
        if (condition == null) {
            throw new NullPointerException("condition");
        }
    }

    public FirstIndex(INDArray x, @NonNull Condition condition, double eps) {
        super(x);
        if (condition == null) {
            throw new NullPointerException("condition");
        }
        this.condition = condition;
        this.compare = condition.getValue();
        this.mode = condition.condtionNum();
        this.eps = eps;
        this.extraArgs = new Object[]{this.compare, eps, (double)this.mode};
    }

    @Override
    public int update(double accum, int accumIdx, double x, int xIdx) {
        return accum >= x ? accumIdx : xIdx;
    }

    @Override
    public int update(float accum, int accumIdx, float x, int xIdx) {
        return accum >= x ? accumIdx : xIdx;
    }

    @Override
    public int update(double accum, int accumIdx, double x, double y, int idx) {
        return accum >= x ? accumIdx : idx;
    }

    @Override
    public int update(float accum, int accumIdx, float x, float y, int idx) {
        return accum >= x ? accumIdx : idx;
    }

    @Override
    public int update(IComplexNumber accum, int accumIdx, IComplexNumber x, int xIdx) {
        return accum.absoluteValue().doubleValue() >= x.absoluteValue().doubleValue() ? accumIdx : xIdx;
    }

    @Override
    public int update(IComplexNumber accum, int accumIdx, double x, int idx) {
        return accum.absoluteValue().doubleValue() >= x ? accumIdx : idx;
    }

    @Override
    public int update(IComplexNumber accum, int accumIdx, double x, double y, int idx) {
        return accum.absoluteValue().doubleValue() >= x ? accumIdx : idx;
    }

    @Override
    public int update(IComplexNumber accum, int accumIdx, IComplexNumber x, IComplexNumber y, int idx) {
        return accum.absoluteValue().doubleValue() >= x.absoluteValue().doubleValue() ? accumIdx : idx;
    }

    @Override
    public int opNum() {
        return 4;
    }

    @Override
    public String name() {
        return "first_index";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return origin;
    }

    @Override
    public float op(float origin, float other) {
        return origin;
    }

    @Override
    public double op(double origin, double other) {
        return origin;
    }

    @Override
    public double op(double origin) {
        return origin;
    }

    @Override
    public float op(float origin) {
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return origin;
    }

    @Override
    public float zeroFloat() {
        return 0.0f;
    }

    @Override
    public float zeroHalf() {
        return this.zeroFloat();
    }

    @Override
    public double zeroDouble() {
        return 0.0;
    }

    @Override
    public IComplexNumber zeroComplex() {
        return Nd4j.createComplexNumber(-1.7976931348623157E308, 0);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        return new FirstIndex(this.x.vectorAlongDimension(index, dimension), this.condition, this.eps);
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        return new FirstIndex(this.x.tensorAlongDimension(index, dimension), this.condition, this.eps);
    }
}

