/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.api.ops.impl.accum.Bias;
import org.nd4j.linalg.api.ops.impl.accum.Mean;
import org.nd4j.linalg.api.ops.impl.accum.Sum;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;

public class Variance
extends BaseAccumulation {
    protected double mean;
    protected double bias;
    protected boolean biasCorrected = true;

    public Variance() {
    }

    public Variance(boolean biasCorrected) {
        this.biasCorrected = biasCorrected;
    }

    public Variance(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
        this.init(x, y, z, n);
    }

    public Variance(INDArray x, INDArray y, long n) {
        this(x, y, x, n);
    }

    public Variance(INDArray x) {
        this(x, null, x, x.lengthLong(), true);
    }

    public Variance(INDArray x, INDArray y) {
        super(x, y);
    }

    public Variance(INDArray x, INDArray y, INDArray z, long n, boolean biasCorrected) {
        super(x, y, z, n);
        this.biasCorrected = biasCorrected;
        this.init(x, y, z, n);
    }

    public Variance(INDArray x, INDArray y, long n, boolean biasCorrected) {
        super(x, y, n);
        this.biasCorrected = biasCorrected;
        this.init(x, y, this.z, n);
    }

    public Variance(INDArray x, boolean biasCorrected) {
        super(x);
        this.biasCorrected = biasCorrected;
        this.init(x, this.y, this.z, this.n);
    }

    public Variance(INDArray x, INDArray y, boolean biasCorrected) {
        super(x, y);
        this.biasCorrected = biasCorrected;
        this.init(x, y, x, x.lengthLong());
    }

    @Override
    public INDArray noOp() {
        return Nd4j.zerosLike(this.x());
    }

    @Override
    public double op(double origin) {
        return origin - this.mean;
    }

    @Override
    public float op(float origin) {
        return (float)((double)origin - this.mean);
    }

    @Override
    public double update(double accum, double x) {
        return accum + x * x;
    }

    @Override
    public double update(double accum, double x, double y) {
        return accum + x * x;
    }

    @Override
    public float update(float accum, float x) {
        return accum + x * x;
    }

    @Override
    public float update(float accum, float x, float y) {
        return accum + x * x;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x) {
        double dev = x - this.mean;
        return accum.add((Number)(dev * dev));
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x, double y) {
        double dev = x - this.mean;
        return accum.add((Number)(dev * dev));
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x) {
        IComplexNumber dev = x.sub((Number)this.mean);
        return accum.add(dev.mul(dev));
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, IComplexNumber y) {
        IComplexNumber dev = x.sub((Number)this.mean);
        return accum.add(dev.mul(dev));
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, double y) {
        IComplexNumber dev = x.sub((Number)this.mean);
        return accum.add(dev.mul(dev));
    }

    @Override
    public int opNum() {
        return 0;
    }

    @Override
    public String name() {
        return "var";
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        Variance ret = this.y() != null ? new Variance(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length()) : new Variance(this.x.vectorAlongDimension(index, dimension));
        ret.setBiasCorrected(this.biasCorrected);
        ret.setApplyFinalTransform(this.applyFinalTransform());
        return ret;
    }

    @Override
    public Variance opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        Variance ret = this.y() != null ? new Variance(xAlongDimension, this.y.tensorAlongDimension(index, dimension), xAlongDimension.length()) : new Variance(this.x.tensorAlongDimension(index, dimension), this.biasCorrected);
        ret.setApplyFinalTransform(this.applyFinalTransform());
        return ret;
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, long n) {
        super.init(x, y, z, n);
        if (Nd4j.executionMode == OpExecutioner.ExecutionMode.JAVA) {
            if (this.biasCorrected) {
                this.bias = Nd4j.getExecutioner().execAndReturn(new Bias(x)).getFinalResult().doubleValue();
            }
            this.mean = Nd4j.getExecutioner().execAndReturn(new Mean(x)).getFinalResult().doubleValue();
        }
    }

    @Override
    public boolean isPassThrough() {
        return true;
    }

    @Override
    public void exec() {
        if (this.biasCorrected) {
            this.bias = Nd4j.getExecutioner().execAndReturn(new Bias(this.x)).getFinalResult().doubleValue();
        }
        this.mean = Nd4j.getExecutioner().execAndReturn(new Mean(this.x)).getFinalResult().doubleValue();
        INDArray xSubMean = this.x.sub(this.mean);
        INDArray squared = xSubMean.muli(xSubMean);
        double accum = Nd4j.getExecutioner().execAndReturn(new Sum(squared)).getFinalResult().doubleValue();
        this.getAndSetFinalResult(accum);
        this.z = Nd4j.scalar(this.finalResult);
    }

    @Override
    public void exec(int ... dimension) {
        if (dimension.length == 1 && dimension[0] == Integer.MAX_VALUE) {
            this.exec();
            return;
        }
        int[] retShape = ArrayUtil.removeIndex((int[])this.x.shape(), (int[])dimension);
        int nOps = this.x.tensorssAlongDimension(dimension);
        this.z = Nd4j.create(retShape);
        for (int i = 0; i < nOps; ++i) {
            double d = Nd4j.getExecutioner().execAndReturn(this.opForDimension(i, dimension)).getFinalResult().doubleValue();
            this.z.putScalar(i, d);
        }
    }

    @Override
    public double combineSubResults(double first, double second) {
        return first + second;
    }

    @Override
    public float combineSubResults(float first, float second) {
        return first + second;
    }

    @Override
    public IComplexNumber combineSubResults(IComplexNumber first, IComplexNumber second) {
        return first.add(second);
    }

    @Override
    public double getAndSetFinalResult(double accum) {
        double result = this.biasCorrected ? (accum - FastMath.pow((double)this.bias, (double)2.0) / (double)this.n()) / ((double)this.n() - 1.0) : accum / (double)this.n();
        this.finalResult = result;
        return result;
    }

    @Override
    public float getAndSetFinalResult(float accum) {
        return (float)this.getAndSetFinalResult((double)accum);
    }

    @Override
    public IComplexNumber getAndSetFinalResult(IComplexNumber accum) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double calculateFinalResult(double accum, long n) {
        double result = this.biasCorrected ? (accum - FastMath.pow((double)this.bias, (double)2.0) / (double)n) / ((double)n - 1.0) : accum / (double)n;
        this.finalResult = result;
        return result;
    }

    @Override
    public float calculateFinalResult(float accum, long n) {
        return (float)this.calculateFinalResult((double)accum, n);
    }

    public boolean isBiasCorrected() {
        return this.biasCorrected;
    }

    public void setBiasCorrected(boolean biasCorrected) {
        this.biasCorrected = biasCorrected;
    }
}

