/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class AMin
extends BaseAccumulation {
    public AMin() {
    }

    public AMin(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public AMin(INDArray x, INDArray y, long n) {
        super(x, y, n);
    }

    public AMin(INDArray x) {
        super(x);
    }

    public AMin(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public int opNum() {
        return 14;
    }

    @Override
    public String name() {
        return "amin";
    }

    @Override
    public float op(float origin, float other) {
        return FastMath.abs((float)origin);
    }

    @Override
    public double op(double origin, double other) {
        return FastMath.abs((double)origin);
    }

    @Override
    public double update(double accum, double x) {
        return FastMath.min((double)FastMath.abs((double)accum), (double)FastMath.abs((double)x));
    }

    @Override
    public double update(double accum, double x, double y) {
        return FastMath.min((double)FastMath.abs((double)accum), (double)FastMath.abs((double)x));
    }

    @Override
    public float update(float accum, float x) {
        return FastMath.min((float)FastMath.abs((float)accum), (float)FastMath.abs((float)x));
    }

    @Override
    public float update(float accum, float x, float y) {
        return FastMath.min((float)FastMath.abs((float)accum), (float)FastMath.abs((float)x));
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x) {
        return accum.absoluteValue().doubleValue() < x ? accum : Nd4j.createComplexNumber(x, 0);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x, double y) {
        return accum.absoluteValue().doubleValue() < x ? accum : Nd4j.createComplexNumber(x, 0);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x) {
        return accum.absoluteValue().doubleValue() < x.absoluteValue().doubleValue() ? accum : x;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, IComplexNumber y) {
        return accum.absoluteValue().doubleValue() < x.absoluteValue().doubleValue() ? accum : x;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, double y) {
        return accum.absoluteValue().doubleValue() < x.absoluteValue().doubleValue() ? accum : x;
    }

    @Override
    public double zeroDouble() {
        return Double.MAX_VALUE;
    }

    @Override
    public float zeroFloat() {
        return Float.MAX_VALUE;
    }

    @Override
    public float zeroHalf() {
        return 65503.0f;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new AMin(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new AMin(this.x.vectorAlongDimension(index, dimension));
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new AMin(xAlongDimension, this.y.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new AMin(this.x.tensorAlongDimension(index, dimension));
    }
}

