/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.IndexAccumulation;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;

public abstract class BaseIndexAccumulation
extends BaseOp
implements IndexAccumulation {
    protected int finalResult;

    public BaseIndexAccumulation() {
    }

    public BaseIndexAccumulation(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
        this.init();
    }

    public BaseIndexAccumulation(INDArray x, INDArray y, long n) {
        this(x, y, x, n);
    }

    public BaseIndexAccumulation(INDArray x) {
        this(x, null, x, x.lengthLong());
    }

    public BaseIndexAccumulation(INDArray x, INDArray y) {
        this(x, y, x, x.lengthLong());
    }

    @Override
    public double zeroDouble() {
        return 0.0;
    }

    @Override
    public float zeroFloat() {
        return 0.0f;
    }

    @Override
    public Pair<Double, Integer> zeroPair() {
        return new Pair((Object)this.zeroDouble(), (Object)-1);
    }

    @Override
    public IComplexNumber zeroComplex() {
        return Nd4j.createComplexNumber(0.0, 0.0);
    }

    private void init() {
        this.init(this.x, this.y, this.x, this.x.lengthLong());
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, long n) {
        super.init(x, y, z, n);
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            this.extraArgs = new Object[]{this.zeroDouble()};
        } else if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
            this.extraArgs = new Object[]{Float.valueOf(this.zeroFloat())};
        } else if (Nd4j.dataType() == DataBuffer.Type.HALF) {
            this.extraArgs = new Object[]{Float.valueOf(this.zeroHalf())};
        }
    }

    @Override
    public int combineSubResults(double first, int idxFirst, double second, int idxSecond) {
        return this.update(first, idxFirst, second, idxSecond);
    }

    @Override
    public int combineSubResults(float first, int idxFirst, float second, int idxSecond) {
        return this.update(first, idxFirst, second, idxSecond);
    }

    @Override
    public Pair<Double, Integer> combineSubResults(Pair<Double, Integer> first, Pair<Double, Integer> second) {
        int idxFirst = (Integer)first.getSecond();
        int idxSecond = (Integer)second.getSecond();
        int idxOut = this.update((Double)first.getFirst(), idxFirst, (double)((Double)second.getFirst()), idxSecond);
        return idxOut == idxFirst ? first : second;
    }

    @Override
    public void setFinalResult(int idx) {
        this.finalResult = idx;
    }

    @Override
    public int getFinalResult() {
        return this.finalResult;
    }
}

