/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jsapi;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.jsapi.JSAPIWriter;
import org.jboss.resteasy.jsapi.ServiceRegistry;
import org.jboss.resteasy.resteasy_jsapi.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jsapi.i18n.Messages;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class JSAPIServlet
extends HttpServlet {
    private static final long serialVersionUID = -1985015444704126795L;
    private ServiceRegistry service;
    private JSAPIWriter apiWriter;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        LogMessages.LOGGER.debug(Messages.MESSAGES.loadingJSAPIServlet());
        this.scanResources();
        LogMessages.LOGGER.debug(Messages.MESSAGES.jsapiServletLoaded());
        ServletContext servletContext = config.getServletContext();
        servletContext.setAttribute(((Object)((Object)this)).getClass().getName(), (Object)this);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        String uri = req.getRequestURL().toString();
        uri = uri.substring(0, uri.length() - req.getServletPath().length());
        LogMessages.LOGGER.debug(Messages.MESSAGES.serving(pathInfo));
        LogMessages.LOGGER.debug(Messages.MESSAGES.query(req.getQueryString()));
        this.apiWriter.writeJavaScript(uri, req, resp, this.service);
    }

    public void scanResources() {
        ServletConfig config = this.getServletConfig();
        ServletContext servletContext = config.getServletContext();
        ResourceMethodRegistry registry = (ResourceMethodRegistry)servletContext.getAttribute(Registry.class.getName());
        ResteasyProviderFactory providerFactory = (ResteasyProviderFactory)servletContext.getAttribute(ResteasyProviderFactory.class.getName());
        String restPath = servletContext.getInitParameter("resteasy.servlet.mapping.prefix");
        this.service = new ServiceRegistry(null, registry, providerFactory, null);
        this.apiWriter = new JSAPIWriter(restPath);
    }
}

