/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.ejb;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.arquillian.testenricher.ejb.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBInjectionEnricher
implements TestEnricher {
    private static final String ANNOTATION_NAME = "javax.ejb.EJB";
    private static final Logger log = Logger.getLogger(TestEnricher.class.getName());
    @Inject
    private Instance<Context> contextInst;

    public void enrich(Object testCase) {
        if (SecurityActions.isClassPresent(ANNOTATION_NAME)) {
            try {
                if (this.createContext() != null) {
                    this.injectClass(testCase);
                }
            }
            catch (Exception e) {
                log.throwing(EJBInjectionEnricher.class.getName(), "enrich", e);
            }
        }
    }

    public Object[] resolve(Method method) {
        return new Object[method.getParameterTypes().length];
    }

    protected List<Field> getFieldsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) throws IllegalArgumentException {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz must be specified");
        }
        if (annotation == null) {
            throw new IllegalArgumentException("annotation must be specified");
        }
        return SecurityActions.getFieldsWithAnnotation(clazz, annotation);
    }

    protected void injectClass(Object testCase) {
        try {
            Class<?> ejbAnnotation = SecurityActions.getThreadContextClassLoader().loadClass(ANNOTATION_NAME);
            List<Field> annotatedFields = SecurityActions.getFieldsWithAnnotation(testCase.getClass(), ejbAnnotation);
            for (Field field : annotatedFields) {
                if (field.get(testCase) != null) continue;
                EJB fieldAnnotation = (EJB)field.getAnnotation(ejbAnnotation);
                try {
                    String mappedName = fieldAnnotation.mappedName();
                    Annotation[] beanName = fieldAnnotation.beanName();
                    String lookup = this.attemptToGet31LookupField(fieldAnnotation);
                    String[] jndiNames = this.resolveJNDINames(field.getType(), mappedName, (String)beanName, lookup);
                    Object ejb = this.lookupEJB(jndiNames);
                    field.set(testCase, ejb);
                }
                catch (Exception e) {
                    log.fine("Could not lookup " + fieldAnnotation + ", other Enrichers might, move on. Exception: " + e.getMessage());
                }
            }
            List<Method> methods = SecurityActions.getMethodsWithAnnotation(testCase.getClass(), ejbAnnotation);
            for (Method method : methods) {
                if (method.getParameterTypes().length != 1) {
                    throw new RuntimeException("@EJB only allowed on single argument methods");
                }
                if (!method.getName().startsWith("set")) {
                    throw new RuntimeException("@EJB only allowed on 'set' methods");
                }
                EJB parameterAnnotation = null;
                for (Annotation annotation : method.getParameterAnnotations()[0]) {
                    if (!EJB.class.isAssignableFrom(annotation.annotationType())) continue;
                    parameterAnnotation = (EJB)annotation;
                }
                String mappedName = null;
                String beanName = null;
                String lookup = null;
                if (parameterAnnotation != null) {
                    mappedName = parameterAnnotation.mappedName();
                    beanName = parameterAnnotation.beanName();
                    lookup = this.attemptToGet31LookupField(parameterAnnotation);
                }
                String[] jndiNames = this.resolveJNDINames(method.getParameterTypes()[0], mappedName, beanName, lookup);
                Object ejb = this.lookupEJB(jndiNames);
                method.invoke(testCase, ejb);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not inject members", e);
        }
    }

    protected String attemptToGet31LookupField(EJB annotation) throws IllegalAccessException, InvocationTargetException {
        String lookup = null;
        try {
            Method m = EJB.class.getMethod("lookup", new Class[0]);
            lookup = String.valueOf(m.invoke((Object)annotation, new Object[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return lookup;
    }

    protected String[] resolveJNDINames(Class<?> fieldType, String mappedName, String beanName, String lookup) {
        MessageFormat msg = new MessageFormat("Trying to resolve JNDI name for field \"{0}\" with mappedName=\"{1}\" and beanName=\"{2}\"");
        log.finer(msg.format(new Object[]{fieldType, mappedName, beanName}));
        Validate.notNull(fieldType, (String)"EJB enriched field cannot to be null.");
        boolean isMappedNameSet = this.hasValue(mappedName);
        boolean isBeanNameSet = this.hasValue(beanName);
        boolean isLookupSet = this.hasValue(lookup);
        if (this.isMoreThanOneValueTrue(isMappedNameSet, isBeanNameSet, isLookupSet)) {
            throw new IllegalStateException("Only one of the @EJB annotation attributes 'mappedName', 'lookup' and 'beanName' can be specified at the same time.");
        }
        String[] jndiNames = isMappedNameSet ? new String[]{mappedName} : (isLookupSet ? new String[]{lookup} : (isBeanNameSet ? new String[]{"java:module/" + beanName + "!" + fieldType.getName()} : this.getJndiNamesForAnonymousEJB(fieldType)));
        return jndiNames;
    }

    protected String[] getJndiNamesForAnonymousEJB(Class<?> fieldType) {
        String[] jndiNames = new String[]{"java:global/test.ear/test/" + fieldType.getSimpleName() + "Bean", "java:global/test.ear/test/" + fieldType.getSimpleName(), "java:global/test/" + fieldType.getSimpleName(), "java:global/test/" + fieldType.getSimpleName() + "Bean", "java:global/test/" + fieldType.getSimpleName() + "/no-interface", "java:module/" + fieldType.getSimpleName(), "test/" + fieldType.getSimpleName() + "Bean/local", "test/" + fieldType.getSimpleName() + "Bean/remote", "test/" + fieldType.getSimpleName() + "/no-interface", fieldType.getSimpleName() + "Bean/local", fieldType.getSimpleName() + "Bean/remote", fieldType.getSimpleName() + "/no-interface", "ejblocal:" + fieldType.getCanonicalName(), fieldType.getCanonicalName()};
        return jndiNames;
    }

    protected Object lookupEJB(String[] jndiNames) throws Exception {
        Context initcontext = this.createContext();
        for (String jndiName : jndiNames) {
            try {
                return initcontext.lookup(jndiName);
            }
            catch (NamingException namingException) {
            }
        }
        throw new NamingException("No EJB found in JNDI, tried the following names: " + this.joinJndiNames(jndiNames));
    }

    protected Context createContext() throws Exception {
        return (Context)this.contextInst.get();
    }

    private String joinJndiNames(String[] strings) {
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            sb.append(string).append(", ");
        }
        return sb.toString();
    }

    private boolean hasValue(String string) {
        return string != null && !string.trim().equals("");
    }

    private boolean isMoreThanOneValueTrue(boolean ... values) {
        boolean trueFound = false;
        for (boolean value : values) {
            if (!value) continue;
            if (trueFound) {
                return true;
            }
            trueFound = true;
        }
        return false;
    }
}

