/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public abstract class BaseOAuthWrapperController
extends AbstractController {
    protected final Logger log = LoggerFactory.getLogger(BaseOAuthWrapperController.class);
    @NotNull
    protected String loginUrl;
    @NotNull
    protected ServicesManager servicesManager;
    @NotNull
    protected TicketRegistry ticketRegistry;
    @NotNull
    protected long timeout;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String method = this.getMethod(request);
        this.log.debug("method : {}", (Object)method);
        return this.internalHandleRequest(method, request, response);
    }

    protected abstract ModelAndView internalHandleRequest(String var1, HttpServletRequest var2, HttpServletResponse var3) throws Exception;

    private String getMethod(HttpServletRequest request) {
        int pos;
        String method = request.getRequestURI();
        if (method.indexOf("?") >= 0) {
            method = StringUtils.substringBefore((String)method, (String)"?");
        }
        if ((pos = method.lastIndexOf("/")) >= 0) {
            method = method.substring(pos + 1);
        }
        return method;
    }

    public void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

