/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.plugin;

import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Set;
import org.apache.tinkerpop.gremlin.groovy.plugin.GremlinPlugin;
import org.apache.tinkerpop.gremlin.groovy.plugin.PluginAcceptor;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.attribute.Geo;
import org.janusgraph.core.attribute.Text;
import org.janusgraph.example.GraphOfTheGodsFactory;
import org.janusgraph.graphdb.tinkerpop.JanusGraphIoRegistry;

public class JanusGraphGremlinPlugin
implements GremlinPlugin {
    private static final String IMPORT = "import ";
    private static final String IMPORT_STATIC = "import static ";
    private static final String DOT_STAR = ".*";
    private static final Set<String> IMPORTS = new HashSet<String>(){
        {
            this.add("import org.janusgraph.core.*");
            this.add("import org.janusgraph.core.attribute.*");
            this.add("import org.janusgraph.core.schema.*");
            this.add(JanusGraphGremlinPlugin.IMPORT + GraphOfTheGodsFactory.class.getName());
            this.add("import org.janusgraph.hadoop.MapReduceIndexManagement");
            this.add("import java.time.*");
            this.add(JanusGraphGremlinPlugin.IMPORT + JanusGraphIoRegistry.class.getName());
            this.add(JanusGraphGremlinPlugin.IMPORT_STATIC + Geo.class.getName() + JanusGraphGremlinPlugin.DOT_STAR);
            this.add(JanusGraphGremlinPlugin.IMPORT_STATIC + Text.class.getName() + JanusGraphGremlinPlugin.DOT_STAR);
            this.add(JanusGraphGremlinPlugin.IMPORT_STATIC + Multiplicity.class.getName() + JanusGraphGremlinPlugin.DOT_STAR);
            this.add(JanusGraphGremlinPlugin.IMPORT_STATIC + Cardinality.class.getName() + JanusGraphGremlinPlugin.DOT_STAR);
            this.add(JanusGraphGremlinPlugin.IMPORT_STATIC + ChronoUnit.class.getName() + JanusGraphGremlinPlugin.DOT_STAR);
        }
    };

    public String getName() {
        return "janusgraph.imports";
    }

    public void pluginTo(PluginAcceptor pluginAcceptor) {
        pluginAcceptor.addImports(IMPORTS);
    }

    public boolean requireRestart() {
        return true;
    }
}

