/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.compiler;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.jamon.compiler.JamonException;
import org.jamon.compiler.RecompilingTemplateManager;
import org.jamon.compiler.TemplateInspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokerTool {
    private final ObjectParser m_objectParser;

    public InvokerTool(ObjectParser p_objectParser) {
        this.m_objectParser = p_objectParser;
    }

    public InvokerTool() {
        this(new DefaultObjectParser());
    }

    private void parseArgString(TemplateInspector p_inspector, Map<String, Object> p_argMap, String p_arg) throws UsageException, TemplateArgumentException {
        int i = p_arg.indexOf("=");
        if (i <= 0) {
            throw new UsageException();
        }
        String name = p_arg.substring(0, i);
        p_argMap.put(name, this.m_objectParser.parseObject(p_inspector.getArgumentType(name), p_arg.substring(i + 1)));
    }

    protected void invoke(String[] args) throws UsageException, IOException, TemplateArgumentException, TemplateInspector.UnknownArgumentsException, TemplateInspector.InvalidTemplateException {
        int a;
        RecompilingTemplateManager.Data data = new RecompilingTemplateManager.Data();
        String outFile = null;
        for (a = 0; a < args.length && args[a].startsWith("-"); ++a) {
            if (args[a].startsWith("--workdir=")) {
                data.setWorkDir(args[a].substring(10));
                continue;
            }
            if (args[a].equals("-w")) {
                if (++a < args.length) {
                    data.setWorkDir(args[a]);
                    continue;
                }
                throw new UsageException();
            }
            if (args[a].startsWith("--srcdir=")) {
                data.setSourceDir(args[a].substring(9));
                continue;
            }
            if (args[a].equals("-s")) {
                if (++a < args.length) {
                    data.setSourceDir(args[a]);
                    continue;
                }
                throw new UsageException();
            }
            if (args[a].startsWith("--output=")) {
                outFile = args[a].substring(9);
                continue;
            }
            if (args[a].equals("-o")) {
                if (++a < args.length) {
                    outFile = args[a];
                    continue;
                }
                throw new UsageException();
            }
            throw new UsageException();
        }
        if (a >= args.length) {
            throw new UsageException();
        }
        String templateName = args[a++];
        TemplateInspector inspector = new TemplateInspector(new RecompilingTemplateManager(data), templateName);
        HashMap<String, Object> argMap = new HashMap<String, Object>();
        while (a < args.length) {
            this.parseArgString(inspector, argMap, args[a++]);
        }
        OutputStreamWriter writer = outFile == null ? new OutputStreamWriter(System.out) : new FileWriter(outFile);
        inspector.render(writer, argMap);
    }

    public static void main(String[] args) throws Exception {
        try {
            new InvokerTool().invoke(args);
        }
        catch (UsageException e) {
            System.err.println("Usage: " + e);
        }
    }

    public static class UsageException
    extends Exception {
        private static final long serialVersionUID = 2006091701L;

        public String toString() {
            return "java " + InvokerTool.class.getName() + " [-o outputfile] " + " [-s templatesourcedir]" + " [-w workdir]" + " template-path [[arg1=val1] ...]";
        }
    }

    public static class TemplateArgumentException
    extends JamonException {
        private static final long serialVersionUID = 2006091701L;

        public TemplateArgumentException(Throwable t) {
            super(t);
        }

        public TemplateArgumentException(String p_msg) {
            super(p_msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultObjectParser
    implements ObjectParser {
        @Override
        public Object parseObject(Class<?> p_type, String p_string) throws TemplateArgumentException {
            try {
                if (p_string == null) {
                    if (p_type.isPrimitive()) {
                        throw new TemplateArgumentException("primitive types cannot be null");
                    }
                    return null;
                }
                if (p_type == String.class) {
                    return p_string;
                }
                if (p_type == Boolean.class || p_type == Boolean.TYPE) {
                    return Boolean.valueOf(p_string);
                }
                if (p_type == Integer.class || p_type == Integer.TYPE) {
                    return Integer.valueOf(p_string);
                }
                if (p_type == Float.class || p_type == Float.TYPE) {
                    return Float.valueOf(p_string);
                }
                if (p_type == Double.class || p_type == Double.TYPE) {
                    return Double.valueOf(p_string);
                }
                if (p_type == Short.class || p_type == Short.TYPE) {
                    return Short.valueOf(p_string);
                }
                if (p_type == Byte.class || p_type == Byte.TYPE) {
                    return Byte.valueOf(p_string);
                }
                return p_type.getConstructor(String.class).newInstance(p_string);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TemplateArgumentException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ObjectParser {
        public Object parseObject(Class<?> var1, String var2) throws TemplateArgumentException;
    }
}

