/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.contour;

import java.awt.image.renderable.ParameterBlock;
import java.util.Arrays;
import java.util.Collection;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ROI;
import org.jaitools.numeric.Range;

public class ContourDescriptor
extends OperationDescriptorImpl {
    public static final String CONTOUR_PROPERTY_NAME = "contours";
    static final int ROI_ARG = 0;
    static final int BAND_ARG = 1;
    static final int LEVELS_ARG = 2;
    static final int INTERVAL_ARG = 3;
    static final int NO_DATA_ARG = 4;
    static final int STRICT_NO_DATA_ARG = 5;
    static final int SIMPLIFY_ARG = 6;
    static final int SMOOTH_ARG = 7;
    private static final String[] paramNames = new String[]{"roi", "band", "levels", "interval", "nodata", "strictNodata", "simplify", "smooth"};
    private static final Class[] paramClasses = new Class[]{ROI.class, Integer.class, Collection.class, Number.class, Collection.class, Boolean.class, Boolean.class, Boolean.class};
    static final Object[] paramDefaults = new Object[]{null, 0, null, null, Arrays.asList(Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.MAX_VALUE), Boolean.TRUE, Boolean.TRUE, Boolean.FALSE};

    public ContourDescriptor() {
        super((String[][])new String[][]{{"GlobalName", "Contour"}, {"LocalName", "Contour"}, {"Vendor", "org.jaitools.media.jai"}, {"Description", "Traces contours based on source image values"}, {"DocURL", "http://code.google.com/p/jaitools/"}, {"Version", "1.1.0"}, {"arg0Desc", paramNames[0] + " an optional ROI"}, {"arg1Desc", paramNames[1] + " (Integer, default=0) " + "the source image band to process"}, {"arg2Desc", paramNames[2] + " (Collection<? extends Number>) " + "values for which to generate contours"}, {"arg3Desc", paramNames[3] + " (Number) " + "interval between contour values (ignored if levels arg is supplied)"}, {"arg4Desc", paramNames[4] + " (Collection) " + "values to be treated as NO_DATA; elements can be Number and/or Range"}, {"arg5Desc", paramNames[5] + " (Boolean, default=true) " + "if true, use strict NODATA exclusion; if false use accept some NODATA"}, {"arg6Desc", paramNames[6] + " (Boolean, default=true) " + "whether to simplify contour lines by removing colinear vertices"}, {"arg7Desc", paramNames[7] + " (Boolean, default=false) " + "whether to smooth contour lines using Bezier interpolation"}}, new String[]{"rendered"}, 1, paramNames, paramClasses, paramDefaults, null);
    }

    protected boolean validateParameters(String modeName, ParameterBlock pb, StringBuffer msg) {
        String nodataErrorMsg = "nodata parameter must be a Collection of Numbers and/or Ranges";
        boolean ok = super.validateParameters(modeName, pb, msg);
        if (ok) {
            Collection levels = (Collection)pb.getObjectParameter(2);
            Object objInterval = pb.getObjectParameter(3);
            if (levels == null || levels.isEmpty()) {
                if (objInterval == null) {
                    ok = false;
                    msg.append("One of levels or interval parameters must be supplied");
                } else {
                    Double interval = ((Number)objInterval).doubleValue();
                    if (interval.isNaN() || interval.isInfinite()) {
                        ok = false;
                        msg.append("interval parameter must not be NaN or infinite");
                    }
                }
            } else if (levels.isEmpty()) {
                ok = false;
                msg.append("levels parameter must be a Collection of one or more numbers");
            }
            Object objc = pb.getObjectParameter(4);
            if (objc != null) {
                if (!(objc instanceof Collection)) {
                    msg.append("nodata parameter must be a Collection of Numbers and/or Ranges");
                    ok = false;
                } else {
                    Collection col = (Collection)objc;
                    for (Object oelem : col) {
                        if (oelem instanceof Number || oelem instanceof Range) continue;
                        msg.append("nodata parameter must be a Collection of Numbers and/or Ranges");
                        ok = false;
                        break;
                    }
                }
            }
        }
        return ok;
    }
}

