/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.glassfish.grizzly.servlet.ApplicationDispatcher;
import org.glassfish.grizzly.servlet.DispatchTargetsInfo;
import org.glassfish.grizzly.servlet.DispatchedHttpServletRequest;
import org.glassfish.grizzly.servlet.DispatchedHttpServletResponse;
import org.glassfish.grizzly.servlet.HttpServletRequestImpl;
import org.glassfish.grizzly.servlet.HttpServletResponseImpl;
import org.glassfish.grizzly.servlet.WebappContext;

class AsyncContextImpl
implements AsyncContext {
    private static final Logger log = Logger.getLogger(AsyncContextImpl.class.getName());
    private static final long DEFAULT_ASYNC_TIMEOUT_MILLIS = -1L;
    static final ExecutorService pool = Executors.newCachedThreadPool(new AsyncPoolThreadFactory());
    private final HttpServletRequestImpl origRequest;
    private ServletRequest servletRequest;
    private ServletResponse servletResponse;
    private boolean isOriginalRequestAndResponse = false;
    private boolean isStartAsyncWithZeroArg = false;
    private final AtomicBoolean isDispatchInProgress = new AtomicBoolean();
    private final ThreadLocal<Boolean> isDispatchInScope = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final AtomicBoolean isOkToConfigure = new AtomicBoolean(true);
    private long asyncTimeoutMillis = -1L;
    private final LinkedList<AsyncListenerContext> asyncListenerContexts = new LinkedList();
    private final AtomicInteger startAsyncCounter = new AtomicInteger(0);
    private final ThreadLocal<Boolean> isStartAsyncInScope = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    AsyncContextImpl(HttpServletRequestImpl origRequest, ServletRequest servletRequest, ServletResponse servletResponse, boolean isStartAsyncWithZeroArg) {
        this.origRequest = origRequest;
        this.init(servletRequest, servletResponse, isStartAsyncWithZeroArg);
    }

    public ServletRequest getRequest() {
        return this.servletRequest;
    }

    HttpServletRequestImpl getOriginalRequest() {
        return this.origRequest;
    }

    public ServletResponse getResponse() {
        return this.servletResponse;
    }

    public boolean hasOriginalRequestAndResponse() {
        return this.isOriginalRequestAndResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch() {
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)this.getZeroArgDispatcher(this.origRequest, this.servletRequest, this.isStartAsyncWithZeroArg);
        this.isDispatchInScope.set(true);
        if (dispatcher != null) {
            if (!this.isDispatchInProgress.compareAndSet(false, true)) throw new IllegalStateException("Asynchronous dispatch already in progress, must call ServletRequest.startAsync first");
            pool.execute(new Handler(this, dispatcher, this.origRequest));
            return;
        } else {
            log.warning("Unable to determine target of zero-arg dispatcher");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)this.servletRequest.getRequestDispatcher(path);
        this.isDispatchInScope.set(true);
        if (dispatcher != null) {
            if (!this.isDispatchInProgress.compareAndSet(false, true)) throw new IllegalStateException("Asynchronous dispatch already in progress, must call ServletRequest.startAsync first");
            pool.execute(new Handler(this, dispatcher, this.origRequest));
            return;
        } else {
            log.log(Level.WARNING, "Unable to acquire RequestDispatcher for {0}", path);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch(ServletContext context, String path) {
        if (path == null || context == null) {
            throw new IllegalArgumentException("Null context or path");
        }
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)context.getRequestDispatcher(path);
        this.isDispatchInScope.set(true);
        if (dispatcher != null) {
            if (!this.isDispatchInProgress.compareAndSet(false, true)) throw new IllegalStateException("Asynchronous dispatch already in progress, must call ServletRequest.startAsync first");
            pool.execute(new Handler(this, dispatcher, this.origRequest));
            return;
        } else {
            log.log(Level.WARNING, "Unable to acquire RequestDispatcher for {0}in servlet context {1}", new Object[]{path, context.getContextPath()});
        }
    }

    boolean isDispatchInScope() {
        return this.isDispatchInScope.get();
    }

    boolean getAndResetDispatchInScope() {
        boolean flag = this.isDispatchInScope.get();
        this.isDispatchInScope.set(Boolean.FALSE);
        return flag;
    }

    public void complete() {
        this.origRequest.asyncComplete();
    }

    public void start(Runnable run) {
        pool.execute(run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AsyncListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        if (!this.isOkToConfigure.get()) {
            throw new IllegalStateException("Must not call AsyncContext.addListener after the container-initiated dispatch during which ServletRequest.startAsync was called has returned to the container");
        }
        LinkedList<AsyncListenerContext> linkedList = this.asyncListenerContexts;
        synchronized (linkedList) {
            this.asyncListenerContexts.add(new AsyncListenerContext(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        if (listener == null || servletRequest == null || servletResponse == null) {
            throw new IllegalArgumentException("Null listener, request, or response");
        }
        if (!this.isOkToConfigure.get()) {
            throw new IllegalStateException("Must not call AsyncContext.addListener after the container-initiated dispatch during which ServletRequest.startAsync was called has returned to the container");
        }
        LinkedList<AsyncListenerContext> linkedList = this.asyncListenerContexts;
        synchronized (linkedList) {
            this.asyncListenerContexts.add(new AsyncListenerContext(listener, servletRequest, servletResponse));
        }
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        AsyncListener listener = null;
        WebappContext ctx = this.origRequest.getContextImpl();
        if (ctx != null) {
            try {
                listener = (AsyncListener)ctx.createListener(clazz);
            }
            catch (Throwable t) {
                throw new ServletException(t);
            }
        }
        return (T)listener;
    }

    public void setTimeout(long timeout) {
        if (!this.isOkToConfigure.get()) {
            throw new IllegalStateException("Must not call AsyncContext.setTimeout after the container-initiated dispatch during which ServletRequest.startAsync was called has returned to the container");
        }
        this.asyncTimeoutMillis = timeout;
    }

    public long getTimeout() {
        return this.asyncTimeoutMillis;
    }

    void reinitialize(ServletRequest servletRequest, ServletResponse servletResponse, boolean isStartAsyncWithZeroArg) {
        this.init(servletRequest, servletResponse, isStartAsyncWithZeroArg);
        this.isDispatchInProgress.set(false);
        this.setOkToConfigure(true);
        this.startAsyncCounter.incrementAndGet();
        this.notifyAsyncListeners(AsyncEventType.START_ASYNC, null);
    }

    boolean isOkToConfigure() {
        return this.isOkToConfigure.get();
    }

    void setOkToConfigure(boolean value) {
        this.isOkToConfigure.set(value);
    }

    private void init(ServletRequest servletRequest, ServletResponse servletResponse, boolean isStartAsyncWithZeroArg) {
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.isOriginalRequestAndResponse = servletRequest instanceof HttpServletRequestImpl && servletResponse instanceof HttpServletResponseImpl || servletRequest instanceof DispatchedHttpServletRequest && servletResponse instanceof DispatchedHttpServletResponse;
        this.isStartAsyncWithZeroArg = isStartAsyncWithZeroArg;
    }

    private RequestDispatcher getZeroArgDispatcher(HttpServletRequestImpl origRequest, ServletRequest servletRequest, boolean isStartAsyncWithZeroArg) {
        String dispatchTarget = null;
        boolean isNamed = false;
        if (!isStartAsyncWithZeroArg && servletRequest instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)servletRequest;
            dispatchTarget = this.getCombinedPath(req);
        } else {
            DispatchTargetsInfo dtInfo = (DispatchTargetsInfo)origRequest.getAttribute("org.apache.catalina.core.ApplicationDispatcher.lastDispatchRequestPathAttr");
            if (dtInfo != null) {
                dispatchTarget = dtInfo.getLastDispatchTarget();
                isNamed = dtInfo.isLastNamedDispatchTarget();
            }
            if (dispatchTarget == null) {
                dispatchTarget = this.getCombinedPath(origRequest);
            }
        }
        RequestDispatcher dispatcher = null;
        if (dispatchTarget != null) {
            dispatcher = isNamed ? servletRequest.getServletContext().getNamedDispatcher(dispatchTarget) : servletRequest.getRequestDispatcher(dispatchTarget);
        }
        return dispatcher;
    }

    private String getCombinedPath(HttpServletRequest req) {
        String servletPath = req.getServletPath();
        if (servletPath == null) {
            return null;
        }
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            return servletPath;
        }
        return servletPath + pathInfo;
    }

    boolean isStartAsyncInScope() {
        return this.isStartAsyncInScope.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAsyncListeners(AsyncEventType asyncEventType, Throwable t) {
        LinkedList<AsyncListenerContext> clone;
        LinkedList<AsyncListenerContext> linkedList = this.asyncListenerContexts;
        synchronized (linkedList) {
            if (this.asyncListenerContexts.isEmpty()) {
                return;
            }
            clone = new LinkedList<AsyncListenerContext>(this.asyncListenerContexts);
            if (asyncEventType.equals((Object)AsyncEventType.START_ASYNC)) {
                this.asyncListenerContexts.clear();
            }
        }
        for (AsyncListenerContext asyncListenerContext : clone) {
            AsyncListener asyncListener = asyncListenerContext.getAsyncListener();
            AsyncEvent asyncEvent = new AsyncEvent((AsyncContext)this, asyncListenerContext.getRequest(), asyncListenerContext.getResponse(), t);
            try {
                switch (asyncEventType) {
                    case COMPLETE: {
                        asyncListener.onComplete(asyncEvent);
                        break;
                    }
                    case TIMEOUT: {
                        asyncListener.onTimeout(asyncEvent);
                        break;
                    }
                    case ERROR: {
                        asyncListener.onError(asyncEvent);
                        break;
                    }
                    case START_ASYNC: {
                        asyncListener.onStartAsync(asyncEvent);
                        break;
                    }
                }
            }
            catch (IOException ioe) {
                log.log(Level.WARNING, "Error invoking AsyncListener", ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        LinkedList<AsyncListenerContext> linkedList = this.asyncListenerContexts;
        synchronized (linkedList) {
            this.asyncListenerContexts.clear();
        }
    }

    private static final class AsyncPoolThreadFactory
    implements ThreadFactory {
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        private final AtomicInteger counter = new AtomicInteger(0);

        private AsyncPoolThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.defaultFactory.newThread(r);
            t.setName("grizzly-web-async-thread-" + this.counter.incrementAndGet());
            return t;
        }
    }

    private static class AsyncListenerContext {
        private final AsyncListener listener;
        private final ServletRequest request;
        private final ServletResponse response;

        public AsyncListenerContext(AsyncListener listener) {
            this(listener, null, null);
        }

        public AsyncListenerContext(AsyncListener listener, ServletRequest request, ServletResponse response) {
            this.listener = listener;
            this.request = request;
            this.response = response;
        }

        public AsyncListener getAsyncListener() {
            return this.listener;
        }

        public ServletRequest getRequest() {
            return this.request;
        }

        public ServletResponse getResponse() {
            return this.response;
        }
    }

    static class Handler
    implements Runnable {
        private final AsyncContextImpl asyncContext;
        private final ApplicationDispatcher dispatcher;
        private final HttpServletRequestImpl origRequest;

        Handler(AsyncContextImpl asyncContext, ApplicationDispatcher dispatcher, HttpServletRequestImpl origRequest) {
            this.asyncContext = asyncContext;
            this.dispatcher = dispatcher;
            this.origRequest = origRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.asyncContext.isStartAsyncInScope.set(Boolean.TRUE);
            this.origRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.ASYNC);
            this.origRequest.setAsyncStarted(false);
            int startAsyncCurrent = this.asyncContext.startAsyncCounter.get();
            try {
                this.dispatcher.dispatch(this.asyncContext.getRequest(), this.asyncContext.getResponse(), DispatcherType.ASYNC);
                if (this.asyncContext.startAsyncCounter.compareAndSet(startAsyncCurrent, startAsyncCurrent)) {
                    this.asyncContext.complete();
                } else {
                    this.origRequest.setAsyncTimeout(this.asyncContext.getTimeout());
                }
            }
            catch (Throwable t) {
                this.asyncContext.notifyAsyncListeners(AsyncEventType.ERROR, t);
                this.asyncContext.getOriginalRequest().errorDispatchAndComplete(t);
            }
            finally {
                this.asyncContext.isStartAsyncInScope.set(Boolean.FALSE);
            }
        }
    }

    static enum AsyncEventType {
        COMPLETE,
        TIMEOUT,
        ERROR,
        START_ASYNC;

    }
}

