/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.config.GenericGrizzlyListener;
import org.glassfish.grizzly.config.GrizzlyListener;
import org.glassfish.grizzly.config.Utils;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.memory.AbstractMemoryManager;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.threadpool.DefaultWorkerThread;
import org.glassfish.hk2.api.ServiceLocator;

public class GrizzlyConfig {
    private static final Logger logger = Logger.getLogger(GrizzlyConfig.class.getName());
    private final NetworkConfig config;
    private final ServiceLocator habitat;
    private final List<GrizzlyListener> listeners = new ArrayList<GrizzlyListener>();

    public GrizzlyConfig(String file) {
        this.habitat = Utils.getServiceLocator(file);
        this.config = (NetworkConfig)this.habitat.getService(NetworkConfig.class, new Annotation[0]);
    }

    public NetworkConfig getConfig() {
        return this.config;
    }

    public List<GrizzlyListener> getListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupNetwork() throws IOException {
        GrizzlyConfig.validateConfig(this.config);
        List<GrizzlyListener> list = this.listeners;
        synchronized (list) {
            AbstractMemoryManager amm = null;
            for (NetworkListener listener : this.config.getNetworkListeners().getNetworkListener()) {
                GenericGrizzlyListener grizzlyListener = new GenericGrizzlyListener();
                grizzlyListener.configure(this.habitat, listener);
                MemoryManager mm = grizzlyListener.transport.getMemoryManager();
                if (mm instanceof AbstractMemoryManager) {
                    amm = (AbstractMemoryManager)mm;
                }
                this.listeners.add(grizzlyListener);
                DefaultWorkerThread thread = new DefaultWorkerThread(Grizzly.DEFAULT_ATTRIBUTE_BUILDER, grizzlyListener.getName(), amm != null ? amm.createThreadLocalPool() : null, (Runnable)new ListenerRunnable(grizzlyListener));
                thread.setDaemon(true);
                thread.start();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warning(e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNetwork() {
        List<GrizzlyListener> list = this.listeners;
        synchronized (list) {
            for (GrizzlyListener listener : this.listeners) {
                try {
                    listener.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.listeners.clear();
        }
    }

    private static void validateConfig(NetworkConfig config) {
        for (NetworkListener listener : config.getNetworkListeners().getNetworkListener()) {
            listener.findHttpProtocol();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException {
        List<GrizzlyListener> list = this.listeners;
        synchronized (list) {
            for (GrizzlyListener listener : this.listeners) {
                try {
                    listener.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.listeners.clear();
        }
    }

    public static boolean toBoolean(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        String v = value.trim();
        return "true".equals(v) || "yes".equals(v) || "on".equals(v) || "1".equals(v);
    }

    private static class ListenerRunnable
    implements Runnable {
        private final GrizzlyListener grizzlyListener;

        public ListenerRunnable(GrizzlyListener grizzlyListener) {
            this.grizzlyListener = grizzlyListener;
        }

        @Override
        public void run() {
            try {
                this.grizzlyListener.start();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

