/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.naming;

import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.jaxb.gco.LocalNameAdapter;
import org.geotoolkit.naming.AbstractName;
import org.geotoolkit.naming.DefaultLocalName;
import org.geotoolkit.naming.DefaultNameSpace;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;

@Immutable
@XmlRootElement(name="ScopedName")
public class DefaultScopedName
extends AbstractName
implements ScopedName {
    private static final long serialVersionUID = -5215955533541748481L;
    private final UnmodifiableArrayList<? extends LocalName> parsedNames;
    private transient GenericName tail;
    private transient GenericName path;

    static AbstractName create(UnmodifiableArrayList<? extends DefaultLocalName> unmodifiableArrayList) {
        ArgumentChecks.ensureNonNull((String)"names", unmodifiableArrayList);
        switch (unmodifiableArrayList.size()) {
            default: {
                return new DefaultScopedName(unmodifiableArrayList);
            }
            case 1: {
                return (AbstractName)unmodifiableArrayList.get(0);
            }
            case 0: 
        }
        throw new IllegalArgumentException(Errors.format((int)58));
    }

    private DefaultScopedName() {
        this.parsedNames = null;
    }

    private DefaultScopedName(UnmodifiableArrayList<? extends LocalName> unmodifiableArrayList) {
        this.parsedNames = unmodifiableArrayList;
    }

    protected DefaultScopedName(NameSpace nameSpace, List<? extends CharSequence> list) {
        ArgumentChecks.ensureNonNull((String)"names", list);
        int n = list.size();
        if (n < 2) {
            throw new IllegalArgumentException(Errors.format((int)73, (Object)"size", (Object)n));
        }
        DefaultNameSpace defaultNameSpace = DefaultNameSpace.wrap(nameSpace);
        boolean bl = defaultNameSpace.isGlobal();
        int n2 = 0;
        Object[] objectArray = new LocalName[n];
        Iterator<? extends CharSequence> iterator = list.iterator();
        CharSequence charSequence = iterator.next();
        do {
            ArgumentChecks.ensureNonNull((String)"name", (Object)charSequence);
            objectArray[n2++] = new DefaultLocalName(defaultNameSpace, charSequence);
            defaultNameSpace = defaultNameSpace.child(charSequence);
            charSequence = iterator.next();
        } while (iterator.hasNext());
        DefaultLocalName defaultLocalName = defaultNameSpace.local(charSequence, null);
        if (bl) {
            defaultLocalName.fullyQualified = this.fullyQualified = this;
        }
        objectArray[n2++] = defaultLocalName;
        if (n2 != n) {
            throw new AssertionError();
        }
        this.parsedNames = UnmodifiableArrayList.wrap((Object[])objectArray);
    }

    protected DefaultScopedName(GenericName genericName, GenericName genericName2) {
        ArgumentChecks.ensureNonNull((String)"path", (Object)genericName);
        ArgumentChecks.ensureNonNull((String)"tail", (Object)genericName2);
        List list = genericName.getParsedNames();
        List list2 = genericName2.getParsedNames();
        int n = list.size();
        Object[] objectArray = new LocalName[n + list2.size()];
        objectArray = list.toArray(objectArray);
        Iterator iterator = list2.iterator();
        LocalName localName = (LocalName)iterator.next();
        LocalName localName2 = objectArray[n - 1];
        NameSpace nameSpace = localName2.scope();
        NameSpace nameSpace2 = localName.scope();
        if (nameSpace2 instanceof DefaultNameSpace && ((DefaultNameSpace)nameSpace2).parent == nameSpace) {
            if (genericName instanceof LocalName) {
                this.tail = genericName2;
            }
            while (true) {
                objectArray[n++] = localName;
                if (iterator.hasNext()) {
                    localName = (LocalName)iterator.next();
                    continue;
                }
                break;
            }
        } else {
            DefaultNameSpace defaultNameSpace = DefaultNameSpace.wrap(nameSpace);
            CharSequence charSequence = DefaultScopedName.name((GenericName)localName2);
            while (true) {
                defaultNameSpace = defaultNameSpace.child(charSequence);
                charSequence = DefaultScopedName.name((GenericName)localName);
                localName = new DefaultLocalName(defaultNameSpace, charSequence);
                objectArray[n++] = localName;
                if (!iterator.hasNext()) break;
                localName = (LocalName)iterator.next();
            }
        }
        if (n != objectArray.length) {
            throw new AssertionError();
        }
        this.parsedNames = UnmodifiableArrayList.wrap((Object[])objectArray);
        if (genericName2 instanceof LocalName) {
            this.path = genericName;
        }
    }

    private static CharSequence name(GenericName genericName) {
        if (genericName instanceof DefaultLocalName) {
            return ((DefaultLocalName)genericName).name;
        }
        InternationalString internationalString = genericName.toInternationalString();
        if (internationalString != null) {
            return internationalString;
        }
        return genericName.toString();
    }

    @Override
    final int arraySize() {
        return this.parsedNames.arraySize();
    }

    @Override
    public NameSpace scope() {
        return this.head().scope();
    }

    public synchronized GenericName tail() {
        if (this.tail == null) {
            int n = this.parsedNames.size();
            switch (n) {
                default: {
                    this.tail = new DefaultScopedName((UnmodifiableArrayList<? extends LocalName>)this.parsedNames.subList(1, n));
                    break;
                }
                case 2: {
                    this.tail = (GenericName)this.parsedNames.get(1);
                    break;
                }
                case 0: 
                case 1: {
                    throw new AssertionError(n);
                }
            }
        }
        return this.tail;
    }

    public synchronized GenericName path() {
        if (this.path == null) {
            int n = this.parsedNames.size();
            switch (n) {
                default: {
                    this.path = new DefaultScopedName((UnmodifiableArrayList<? extends LocalName>)this.parsedNames.subList(0, n - 1));
                    break;
                }
                case 2: {
                    this.path = (GenericName)this.parsedNames.get(0);
                    break;
                }
                case 0: 
                case 1: {
                    throw new AssertionError(n);
                }
            }
        }
        return this.path;
    }

    @Override
    @XmlJavaTypeAdapter(value=LocalNameAdapter.class)
    @XmlElement(name="parsedName", required=true)
    public List<? extends LocalName> getParsedNames() {
        return this.parsedNames;
    }
}

