/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.naming;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.naming.DefaultLocalName;
import org.geotoolkit.naming.DefaultMemberName;
import org.geotoolkit.naming.DefaultNameSpace;
import org.geotoolkit.naming.DefaultScopedName;
import org.geotoolkit.naming.DefaultTypeName;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.DefaultInternationalString;
import org.geotoolkit.util.SimpleInternationalString;
import org.geotoolkit.util.collection.WeakHashSet;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.MemberName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;
import org.opengis.util.TypeName;

@ThreadSafe
public class DefaultNameFactory
extends Factory
implements NameFactory {
    private final WeakHashSet<GenericName> pool = WeakHashSet.newInstance(GenericName.class);

    public Citation getVendor() {
        return Citations.GEOTOOLKIT;
    }

    public InternationalString createInternationalString(Map<Locale, String> map) {
        ArgumentChecks.ensureNonNull((String)"strings", map);
        switch (map.size()) {
            case 0: {
                throw new IllegalArgumentException(Errors.format((int)59));
            }
            case 1: {
                return new SimpleInternationalString(map.values().iterator().next());
            }
        }
        return new DefaultInternationalString(map);
    }

    private static String getString(Map<String, ?> map, String string) {
        Object obj;
        if (map != null && (obj = map.get(string)) != null) {
            return obj.toString();
        }
        return null;
    }

    public NameSpace createNameSpace(GenericName genericName, Map<String, ?> map) {
        boolean bl;
        String string;
        ArgumentChecks.ensureNonNull((String)"name", (Object)genericName);
        String string2 = DefaultNameFactory.getString(map, "separator");
        if (string2 == null) {
            string2 = ":";
        }
        if ((string = DefaultNameFactory.getString(map, "separator.head")) == null) {
            string = string2;
        }
        if ((bl = string2.isEmpty()) || string.isEmpty()) {
            throw new IllegalArgumentException(Errors.format((int)72, (Object)(bl ? "separator" : "separator.head")));
        }
        return DefaultNameSpace.forName(genericName.toFullyQualifiedName(), string, string2);
    }

    @Deprecated
    public NameSpace createNameSpace(GenericName genericName) {
        return this.createNameSpace(genericName, null);
    }

    public TypeName createTypeName(NameSpace nameSpace, CharSequence charSequence) {
        return (TypeName)this.pool.unique((Object)new DefaultTypeName(nameSpace, charSequence));
    }

    public MemberName createMemberName(NameSpace nameSpace, CharSequence charSequence, TypeName typeName) {
        return (MemberName)this.pool.unique((Object)new DefaultMemberName(nameSpace, charSequence, typeName));
    }

    public LocalName createLocalName(NameSpace nameSpace, CharSequence charSequence) {
        if (nameSpace instanceof DefaultNameSpace) {
            return ((DefaultNameSpace)nameSpace).local(charSequence, null);
        }
        return (LocalName)this.pool.unique((Object)new DefaultLocalName(nameSpace, charSequence));
    }

    public GenericName createGenericName(NameSpace nameSpace, CharSequence ... charSequenceArray) {
        ArgumentChecks.ensureNonNull((String)"parsedNames", (Object)charSequenceArray);
        switch (charSequenceArray.length) {
            default: {
                return (GenericName)this.pool.unique((Object)new DefaultScopedName(nameSpace, Arrays.asList(charSequenceArray)));
            }
            case 1: {
                return this.createLocalName(nameSpace, charSequenceArray[0]);
            }
            case 0: 
        }
        throw new IllegalArgumentException(Errors.format((int)58));
    }

    public GenericName parseGenericName(NameSpace nameSpace, CharSequence charSequence) {
        int n;
        String string = nameSpace instanceof DefaultNameSpace ? ((DefaultNameSpace)nameSpace).separator : ":";
        int n2 = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        String string2 = ((Object)charSequence).toString();
        while ((n = string2.indexOf(string, n3)) >= 0) {
            arrayList.add(string2.substring(n3, n));
            n3 = n + n2;
        }
        arrayList.add(string2.substring(n3));
        if (arrayList.size() == 1) {
            return this.createLocalName(nameSpace, charSequence);
        }
        return this.createGenericName(nameSpace, arrayList.toArray(new String[arrayList.size()]));
    }

    private GenericName createFromObject(Object object) {
        ArgumentChecks.ensureNonNull((String)"value", (Object)object);
        if (object instanceof GenericName) {
            return (GenericName)object;
        }
        if (object instanceof Identifier) {
            return this.parseGenericName(null, ((Identifier)object).getCode());
        }
        if (object instanceof CharSequence) {
            return this.parseGenericName(null, (CharSequence)object);
        }
        return null;
    }

    public GenericName[] toArray(Object object) throws ClassCastException {
        block7: {
            Object[] objectArray;
            GenericName genericName;
            block9: {
                block8: {
                    genericName = this.createFromObject(object);
                    if (genericName != null) {
                        return new GenericName[]{genericName};
                    }
                    if (!(object instanceof Collection)) break block8;
                    objectArray = ((Collection)object).toArray();
                    break block9;
                }
                if (!(object instanceof Object[])) break block7;
                objectArray = (Object[])object;
            }
            if (objectArray instanceof GenericName[]) {
                return (GenericName[])objectArray;
            }
            GenericName[] genericNameArray = new GenericName[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                genericName = this.createFromObject(object);
                if (genericName != null) {
                    genericNameArray[i] = genericName;
                    continue;
                }
                break block7;
            }
            return genericNameArray;
        }
        throw new ClassCastException(Errors.format((int)226, object.getClass()));
    }
}

