/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.quality;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.metadata.iso.quality.AbstractResult;
import org.opengis.metadata.quality.QuantitativeResult;
import org.opengis.metadata.quality.Result;
import org.opengis.util.InternationalString;
import org.opengis.util.MemberName;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

@ThreadSafe
@XmlType(name="DQ_QuantitativeResult_Type", propOrder={"valueType", "valueUnit", "errorStatistic"})
@XmlRootElement(name="DQ_QuantitativeResult")
public class DefaultQuantitativeResult
extends AbstractResult
implements QuantitativeResult {
    private static final long serialVersionUID = 1230713599561236060L;
    private List<Record> values;
    private RecordType valueType;
    private Unit<?> valueUnit;
    private InternationalString errorStatistic;

    public DefaultQuantitativeResult() {
    }

    public DefaultQuantitativeResult(QuantitativeResult quantitativeResult) {
        super((Result)quantitativeResult);
    }

    public DefaultQuantitativeResult(double[] dArray) {
        this.setValues(dArray);
    }

    public static DefaultQuantitativeResult castOrCopy(QuantitativeResult quantitativeResult) {
        return quantitativeResult == null || quantitativeResult instanceof DefaultQuantitativeResult ? (DefaultQuantitativeResult)quantitativeResult : new DefaultQuantitativeResult(quantitativeResult);
    }

    public synchronized List<Record> getValues() {
        this.values = this.nonNullList(this.values, Record.class);
        return this.values;
    }

    public synchronized void setValues(List<Record> list) {
        this.values = this.copyList(list, this.values, Record.class);
    }

    public synchronized void setValues(double[] dArray) {
        List<Record> list;
        if (dArray == null) {
            list = null;
        } else {
            Record[] recordArray = new Record[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                recordArray[i] = new SimpleRecord(dArray[i]);
            }
            list = Arrays.asList(recordArray);
        }
        this.setValues(list);
    }

    @XmlElement(name="valueType")
    public synchronized RecordType getValueType() {
        return this.valueType;
    }

    public synchronized void setValueType(RecordType recordType) {
        this.checkWritePermission();
        this.valueType = recordType;
    }

    @XmlElement(name="valueUnit", required=true)
    public synchronized Unit<?> getValueUnit() {
        return this.valueUnit;
    }

    public synchronized void setValueUnit(Unit<?> unit) {
        this.checkWritePermission();
        this.valueUnit = unit;
    }

    @XmlElement(name="errorStatistic")
    public synchronized InternationalString getErrorStatistic() {
        return this.errorStatistic;
    }

    public synchronized void setErrorStatistic(InternationalString internationalString) {
        this.checkWritePermission();
        this.errorStatistic = internationalString;
    }

    @Deprecated
    private static final class SimpleRecord
    implements Record,
    Serializable {
        private final Map<MemberName, Object> map;

        public SimpleRecord(double d) {
            this.map = Collections.singletonMap(null, d);
        }

        public RecordType getRecordType() {
            throw new UnsupportedOperationException();
        }

        public Map<MemberName, Object> getAttributes() {
            return this.map;
        }

        public Object locate(MemberName memberName) {
            throw new UnsupportedOperationException();
        }

        public void set(MemberName memberName, Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object object) {
            if (object instanceof SimpleRecord) {
                return ((Object)this.map).equals(((SimpleRecord)object).map);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.map).hashCode();
        }
    }
}

