/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.lineage;

import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.jaxb.gmi.LE_ProcessStep;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.lineage.ProcessStep;
import org.opengis.metadata.lineage.ProcessStepReport;
import org.opengis.metadata.lineage.Processing;
import org.opengis.metadata.lineage.Source;
import org.opengis.util.InternationalString;

@ThreadSafe
@XmlType(name="LI_ProcessStep_Type", propOrder={"description", "rationale", "date", "processors", "sources", "outputs", "processingInformation", "reports"})
@XmlRootElement(name="LI_ProcessStep")
@XmlSeeAlso(value={LE_ProcessStep.class})
public class DefaultProcessStep
extends MetadataEntity
implements ProcessStep {
    private static final long serialVersionUID = 8151975419390308233L;
    private InternationalString description;
    private InternationalString rationale;
    private long date;
    private Collection<ResponsibleParty> processors;
    private Collection<Source> sources;
    private Collection<Source> outputs;
    private Processing processingInformation;
    private Collection<ProcessStepReport> reports;

    public DefaultProcessStep() {
        this.date = Long.MIN_VALUE;
    }

    public DefaultProcessStep(ProcessStep processStep) {
        super(processStep);
        if (processStep != null && this.date == 0L && processStep.getDate() == null) {
            this.date = Long.MIN_VALUE;
        }
    }

    public DefaultProcessStep(InternationalString internationalString) {
        this();
        this.setDescription(internationalString);
    }

    public static DefaultProcessStep castOrCopy(ProcessStep processStep) {
        return processStep == null || processStep instanceof DefaultProcessStep ? (DefaultProcessStep)processStep : new DefaultProcessStep(processStep);
    }

    @XmlElement(name="description", required=true)
    public synchronized InternationalString getDescription() {
        return this.description;
    }

    public synchronized void setDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.description = internationalString;
    }

    @XmlElement(name="rationale")
    public synchronized InternationalString getRationale() {
        return this.rationale;
    }

    public synchronized void setRationale(InternationalString internationalString) {
        this.checkWritePermission();
        this.rationale = internationalString;
    }

    @XmlElement(name="dateTime")
    public synchronized Date getDate() {
        return this.date != Long.MIN_VALUE ? new Date(this.date) : null;
    }

    public synchronized void setDate(Date date) {
        this.checkWritePermission();
        this.date = date != null ? date.getTime() : Long.MIN_VALUE;
    }

    @XmlElement(name="processor")
    public synchronized Collection<ResponsibleParty> getProcessors() {
        this.processors = this.nonNullCollection(this.processors, ResponsibleParty.class);
        return this.processors;
    }

    public synchronized void setProcessors(Collection<? extends ResponsibleParty> collection) {
        this.processors = this.copyCollection(collection, this.processors, ResponsibleParty.class);
    }

    @XmlElement(name="source")
    public synchronized Collection<Source> getSources() {
        this.sources = this.nonNullCollection(this.sources, Source.class);
        return this.sources;
    }

    public synchronized void setSources(Collection<? extends Source> collection) {
        this.sources = this.copyCollection(collection, this.sources, Source.class);
    }

    @XmlElement(name="output", namespace="http://www.isotc211.org/2005/gmi")
    public synchronized Collection<Source> getOutputs() {
        this.outputs = this.nonNullCollection(this.outputs, Source.class);
        return this.outputs;
    }

    public synchronized void setOutputs(Collection<? extends Source> collection) {
        this.outputs = this.copyCollection(collection, this.outputs, Source.class);
    }

    @XmlElement(name="processingInformation", namespace="http://www.isotc211.org/2005/gmi")
    public synchronized Processing getProcessingInformation() {
        return this.processingInformation;
    }

    public synchronized void setProcessingInformation(Processing processing) {
        this.checkWritePermission();
        this.processingInformation = processing;
    }

    @XmlElement(name="report", namespace="http://www.isotc211.org/2005/gmi")
    public synchronized Collection<ProcessStepReport> getReports() {
        this.reports = this.nonNullCollection(this.reports, ProcessStepReport.class);
        return this.reports;
    }

    public synchronized void setReports(Collection<? extends ProcessStepReport> collection) {
        this.reports = this.copyCollection(collection, this.reports, ProcessStepReport.class);
    }
}

