/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.identification;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.geotoolkit.metadata.iso.identification.DefaultDataIdentification;
import org.geotoolkit.metadata.iso.identification.DefaultServiceIdentification;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.identification.AggregateInformation;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.Keywords;
import org.opengis.metadata.identification.Progress;
import org.opengis.metadata.identification.ServiceIdentification;
import org.opengis.metadata.identification.Usage;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.util.InternationalString;

@ThreadSafe
@XmlType(name="AbstractMD_Identification_Type", propOrder={"citation", "abstract", "purpose", "credits", "status", "pointOfContacts", "resourceMaintenances", "graphicOverviews", "resourceFormats", "descriptiveKeywords", "resourceSpecificUsages", "resourceConstraints", "aggregationInfo"})
@XmlRootElement(name="MD_Identification")
@XmlSeeAlso(value={DefaultDataIdentification.class, DefaultServiceIdentification.class})
public class AbstractIdentification
extends MetadataEntity
implements Identification {
    private static final long serialVersionUID = 5794381277658853611L;
    private Citation citation;
    private InternationalString abstracts;
    private InternationalString purpose;
    private Collection<String> credits;
    private Collection<Progress> status;
    private Collection<ResponsibleParty> pointOfContacts;
    private Collection<MaintenanceInformation> resourceMaintenances;
    private Collection<BrowseGraphic> graphicOverviews;
    private Collection<Format> resourceFormats;
    private Collection<Keywords> descriptiveKeywords;
    private Collection<Usage> resourceSpecificUsages;
    private Collection<Constraints> resourceConstraints;
    private Collection<AggregateInformation> aggregationInfo;

    public AbstractIdentification() {
    }

    public AbstractIdentification(Identification identification) {
        super(identification);
    }

    public AbstractIdentification(Citation citation, InternationalString internationalString) {
        this.setCitation(citation);
        this.setAbstract(internationalString);
    }

    public static AbstractIdentification castOrCopy(Identification identification) {
        if (identification instanceof DataIdentification) {
            return DefaultDataIdentification.castOrCopy((DataIdentification)identification);
        }
        if (identification instanceof ServiceIdentification) {
            return DefaultServiceIdentification.castOrCopy((ServiceIdentification)identification);
        }
        return identification == null || identification instanceof AbstractIdentification ? (AbstractIdentification)identification : new AbstractIdentification(identification);
    }

    @XmlElement(name="citation", required=true)
    public synchronized Citation getCitation() {
        return this.citation;
    }

    public synchronized void setCitation(Citation citation) {
        this.checkWritePermission();
        this.citation = citation;
    }

    @XmlElement(name="abstract", required=true)
    public synchronized InternationalString getAbstract() {
        return this.abstracts;
    }

    public synchronized void setAbstract(InternationalString internationalString) {
        this.checkWritePermission();
        this.abstracts = internationalString;
    }

    @XmlElement(name="purpose")
    public synchronized InternationalString getPurpose() {
        return this.purpose;
    }

    public synchronized void setPurpose(InternationalString internationalString) {
        this.checkWritePermission();
        this.purpose = internationalString;
    }

    @XmlElement(name="credit")
    public synchronized Collection<String> getCredits() {
        this.credits = this.nonNullCollection(this.credits, String.class);
        return this.credits;
    }

    public synchronized void setCredits(Collection<? extends String> collection) {
        this.credits = this.copyCollection(collection, this.credits, String.class);
    }

    @XmlElement(name="status")
    public synchronized Collection<Progress> getStatus() {
        this.status = this.nonNullCollection(this.status, Progress.class);
        return this.status;
    }

    public synchronized void setStatus(Collection<? extends Progress> collection) {
        this.status = this.copyCollection(collection, this.status, Progress.class);
    }

    @XmlElement(name="pointOfContact")
    public synchronized Collection<ResponsibleParty> getPointOfContacts() {
        this.pointOfContacts = this.nonNullCollection(this.pointOfContacts, ResponsibleParty.class);
        return this.pointOfContacts;
    }

    public synchronized void setPointOfContacts(Collection<? extends ResponsibleParty> collection) {
        this.pointOfContacts = this.copyCollection(collection, this.pointOfContacts, ResponsibleParty.class);
    }

    @XmlElement(name="resourceMaintenance")
    public synchronized Collection<MaintenanceInformation> getResourceMaintenances() {
        this.resourceMaintenances = this.nonNullCollection(this.resourceMaintenances, MaintenanceInformation.class);
        return this.resourceMaintenances;
    }

    public synchronized void setResourceMaintenances(Collection<? extends MaintenanceInformation> collection) {
        this.resourceMaintenances = this.copyCollection(collection, this.resourceMaintenances, MaintenanceInformation.class);
    }

    @XmlElement(name="graphicOverview")
    public synchronized Collection<BrowseGraphic> getGraphicOverviews() {
        this.graphicOverviews = this.nonNullCollection(this.graphicOverviews, BrowseGraphic.class);
        return this.graphicOverviews;
    }

    public synchronized void setGraphicOverviews(Collection<? extends BrowseGraphic> collection) {
        this.graphicOverviews = this.copyCollection(collection, this.graphicOverviews, BrowseGraphic.class);
    }

    @XmlElement(name="resourceFormat")
    public synchronized Collection<Format> getResourceFormats() {
        this.resourceFormats = this.nonNullCollection(this.resourceFormats, Format.class);
        return this.resourceFormats;
    }

    public synchronized void setResourceFormats(Collection<? extends Format> collection) {
        this.resourceFormats = this.copyCollection(collection, this.resourceFormats, Format.class);
    }

    @XmlElement(name="descriptiveKeywords")
    public synchronized Collection<Keywords> getDescriptiveKeywords() {
        this.descriptiveKeywords = this.nonNullCollection(this.descriptiveKeywords, Keywords.class);
        return this.descriptiveKeywords;
    }

    public synchronized void setDescriptiveKeywords(Collection<? extends Keywords> collection) {
        this.descriptiveKeywords = this.copyCollection(collection, this.descriptiveKeywords, Keywords.class);
    }

    @XmlElement(name="resourceSpecificUsage")
    public synchronized Collection<Usage> getResourceSpecificUsages() {
        this.resourceSpecificUsages = this.nonNullCollection(this.resourceSpecificUsages, Usage.class);
        return this.resourceSpecificUsages;
    }

    public synchronized void setResourceSpecificUsages(Collection<? extends Usage> collection) {
        this.resourceSpecificUsages = this.copyCollection(collection, this.resourceSpecificUsages, Usage.class);
    }

    @XmlElement(name="resourceConstraints")
    public synchronized Collection<Constraints> getResourceConstraints() {
        this.resourceConstraints = this.nonNullCollection(this.resourceConstraints, Constraints.class);
        return this.resourceConstraints;
    }

    public synchronized void setResourceConstraints(Collection<? extends Constraints> collection) {
        this.resourceConstraints = this.copyCollection(collection, this.resourceConstraints, Constraints.class);
    }

    @XmlElement(name="aggregationInfo")
    public synchronized Collection<AggregateInformation> getAggregationInfo() {
        this.aggregationInfo = this.nonNullCollection(this.aggregationInfo, AggregateInformation.class);
        return this.aggregationInfo;
    }

    public synchronized void setAggregationInfo(Collection<? extends AggregateInformation> collection) {
        this.aggregationInfo = this.copyCollection(collection, this.aggregationInfo, AggregateInformation.class);
    }
}

