/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.extent;

import java.awt.geom.Rectangle2D;
import java.text.FieldPosition;
import java.util.Locale;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.referencing.ProxyForMetadata;
import org.geotoolkit.lang.ValueRange;
import org.geotoolkit.measure.AngleFormat;
import org.geotoolkit.measure.Latitude;
import org.geotoolkit.measure.Longitude;
import org.geotoolkit.metadata.iso.extent.AbstractGeographicExtent;
import org.geotoolkit.metadata.iso.extent.DefaultExtent;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

@ThreadSafe
@XmlType(name="EX_GeographicBoundingBox_Type", propOrder={"westBoundLongitude", "eastBoundLongitude", "southBoundLatitude", "northBoundLatitude"})
@XmlRootElement(name="EX_GeographicBoundingBox")
public class DefaultGeographicBoundingBox
extends AbstractGeographicExtent
implements GeographicBoundingBox {
    private static final long serialVersionUID = -3278089380004172514L;
    public static final GeographicBoundingBox WORLD;
    private double westBoundLongitude;
    private double eastBoundLongitude;
    private double southBoundLatitude;
    private double northBoundLatitude;

    public DefaultGeographicBoundingBox() {
        this.westBoundLongitude = Double.NaN;
        this.eastBoundLongitude = Double.NaN;
        this.southBoundLatitude = Double.NaN;
        this.northBoundLatitude = Double.NaN;
    }

    public DefaultGeographicBoundingBox(GeographicBoundingBox geographicBoundingBox) {
        this.setBounds(geographicBoundingBox);
    }

    public DefaultGeographicBoundingBox(Envelope envelope) throws TransformException {
        super(true);
        ProxyForMetadata.getInstance().copy(envelope, this);
    }

    public DefaultGeographicBoundingBox(Rectangle2D rectangle2D, CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        super(true);
        ProxyForMetadata.getInstance().copy(rectangle2D, coordinateReferenceSystem, this);
    }

    public DefaultGeographicBoundingBox(Rectangle2D rectangle2D) {
        this(rectangle2D.getMinX(), rectangle2D.getMaxX(), rectangle2D.getMinY(), rectangle2D.getMaxY());
    }

    public DefaultGeographicBoundingBox(double d, double d2, double d3, double d4) throws IllegalArgumentException {
        super(true);
        this.setBounds(d, d2, d3, d4);
    }

    public static DefaultGeographicBoundingBox castOrCopy(GeographicBoundingBox geographicBoundingBox) {
        return geographicBoundingBox == null || geographicBoundingBox instanceof DefaultGeographicBoundingBox ? (DefaultGeographicBoundingBox)geographicBoundingBox : new DefaultGeographicBoundingBox(geographicBoundingBox);
    }

    @ValueRange(minimum=-180.0, maximum=180.0)
    @XmlElement(name="westBoundLongitude", required=true)
    public synchronized double getWestBoundLongitude() {
        return this.westBoundLongitude;
    }

    public synchronized void setWestBoundLongitude(double d) {
        this.checkWritePermission();
        this.westBoundLongitude = d;
    }

    @ValueRange(minimum=-180.0, maximum=180.0)
    @XmlElement(name="eastBoundLongitude", required=true)
    public synchronized double getEastBoundLongitude() {
        return this.eastBoundLongitude;
    }

    public synchronized void setEastBoundLongitude(double d) {
        this.checkWritePermission();
        this.eastBoundLongitude = d;
    }

    @ValueRange(minimum=-90.0, maximum=90.0)
    @XmlElement(name="southBoundLatitude", required=true)
    public synchronized double getSouthBoundLatitude() {
        return this.southBoundLatitude;
    }

    public synchronized void setSouthBoundLatitude(double d) {
        this.checkWritePermission();
        this.southBoundLatitude = d;
    }

    @ValueRange(minimum=-90.0, maximum=90.0)
    @XmlElement(name="northBoundLatitude", required=true)
    public synchronized double getNorthBoundLatitude() {
        return this.northBoundLatitude;
    }

    public synchronized void setNorthBoundLatitude(double d) {
        this.checkWritePermission();
        this.northBoundLatitude = d;
    }

    public synchronized void setBounds(double d, double d2, double d3, double d4) throws IllegalArgumentException {
        int n;
        double d5;
        double d6;
        this.checkWritePermission();
        if (d > d2) {
            d6 = d;
            d5 = d2;
            n = 184;
        } else if (d3 > d4) {
            d6 = d3;
            d5 = d4;
            n = 170;
        } else {
            this.westBoundLongitude = d;
            this.eastBoundLongitude = d2;
            this.southBoundLatitude = d3;
            this.northBoundLatitude = d4;
            return;
        }
        String string = Vocabulary.format((int)n);
        string = Errors.format((int)72, (Object)string);
        string = string + ' ' + Errors.format((int)14, (Object)d6, (Object)d5);
        throw new IllegalArgumentException(string);
    }

    public void setBounds(Rectangle2D rectangle2D) {
        DefaultExtent.ensureNonNull("bounds", rectangle2D);
        this.setBounds(rectangle2D.getMinX(), rectangle2D.getMaxX(), rectangle2D.getMinY(), rectangle2D.getMaxY());
    }

    public void setBounds(GeographicBoundingBox geographicBoundingBox) {
        DefaultExtent.ensureNonNull("box", geographicBoundingBox);
        this.setInclusion(geographicBoundingBox.getInclusion());
        this.setBounds(geographicBoundingBox.getWestBoundLongitude(), geographicBoundingBox.getEastBoundLongitude(), geographicBoundingBox.getSouthBoundLatitude(), geographicBoundingBox.getNorthBoundLatitude());
    }

    public synchronized void add(GeographicBoundingBox geographicBoundingBox) {
        this.checkWritePermission();
        double d = geographicBoundingBox.getWestBoundLongitude();
        double d2 = geographicBoundingBox.getEastBoundLongitude();
        double d3 = geographicBoundingBox.getSouthBoundLatitude();
        double d4 = geographicBoundingBox.getNorthBoundLatitude();
        Boolean bl = this.getInclusion();
        DefaultExtent.ensureNonNull("inclusion", bl);
        Boolean bl2 = geographicBoundingBox.getInclusion();
        DefaultExtent.ensureNonNull("inclusion", bl2);
        if (bl.booleanValue() == bl2.booleanValue()) {
            if (d < this.westBoundLongitude) {
                this.westBoundLongitude = d;
            }
            if (d2 > this.eastBoundLongitude) {
                this.eastBoundLongitude = d2;
            }
            if (d3 < this.southBoundLatitude) {
                this.southBoundLatitude = d3;
            }
            if (d4 > this.northBoundLatitude) {
                this.northBoundLatitude = d4;
            }
        } else {
            if (d3 <= this.southBoundLatitude && d4 >= this.northBoundLatitude) {
                if (d > this.westBoundLongitude) {
                    this.westBoundLongitude = d;
                }
                if (d2 < this.eastBoundLongitude) {
                    this.eastBoundLongitude = d2;
                }
            }
            if (d <= this.westBoundLongitude && d2 >= this.eastBoundLongitude) {
                if (d3 > this.southBoundLatitude) {
                    this.southBoundLatitude = d3;
                }
                if (d4 < this.northBoundLatitude) {
                    this.northBoundLatitude = d4;
                }
            }
        }
    }

    public synchronized void intersect(GeographicBoundingBox geographicBoundingBox) {
        this.checkWritePermission();
        Boolean bl = this.getInclusion();
        DefaultExtent.ensureNonNull("inclusion", bl);
        Boolean bl2 = geographicBoundingBox.getInclusion();
        DefaultExtent.ensureNonNull("inclusion", bl2);
        if (bl.booleanValue() != bl2.booleanValue()) {
            throw new IllegalArgumentException(Errors.format((int)72, (Object)"box"));
        }
        double d = geographicBoundingBox.getWestBoundLongitude();
        double d2 = geographicBoundingBox.getEastBoundLongitude();
        double d3 = geographicBoundingBox.getSouthBoundLatitude();
        double d4 = geographicBoundingBox.getNorthBoundLatitude();
        if (d > this.westBoundLongitude) {
            this.westBoundLongitude = d;
        }
        if (d2 < this.eastBoundLongitude) {
            this.eastBoundLongitude = d2;
        }
        if (d3 > this.southBoundLatitude) {
            this.southBoundLatitude = d3;
        }
        if (d4 < this.northBoundLatitude) {
            this.northBoundLatitude = d4;
        }
        if (this.westBoundLongitude > this.eastBoundLongitude) {
            this.westBoundLongitude = this.eastBoundLongitude = 0.5 * (this.westBoundLongitude + this.eastBoundLongitude);
        }
        if (this.southBoundLatitude > this.northBoundLatitude) {
            this.southBoundLatitude = this.northBoundLatitude = 0.5 * (this.southBoundLatitude + this.northBoundLatitude);
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        return Double.isNaN(this.eastBoundLongitude) && Double.isNaN(this.westBoundLongitude) && Double.isNaN(this.northBoundLatitude) && Double.isNaN(this.southBoundLatitude);
    }

    @Override
    public synchronized boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == DefaultGeographicBoundingBox.class) {
            DefaultGeographicBoundingBox defaultGeographicBoundingBox = (DefaultGeographicBoundingBox)object;
            return Utilities.equals((Object)this.getInclusion(), (Object)defaultGeographicBoundingBox.getInclusion()) && Utilities.equals((double)this.southBoundLatitude, (double)defaultGeographicBoundingBox.southBoundLatitude) && Utilities.equals((double)this.northBoundLatitude, (double)defaultGeographicBoundingBox.northBoundLatitude) && Utilities.equals((double)this.eastBoundLongitude, (double)defaultGeographicBoundingBox.eastBoundLongitude) && Utilities.equals((double)this.westBoundLongitude, (double)defaultGeographicBoundingBox.westBoundLongitude);
        }
        return super.equals(object, comparisonMode);
    }

    @Override
    public synchronized String toString() {
        return DefaultGeographicBoundingBox.toString(this, "DD\u00b0MM\u2032SS.s\u2033", null);
    }

    public static String toString(GeographicBoundingBox geographicBoundingBox, String string, Locale locale) {
        AngleFormat angleFormat = locale != null ? new AngleFormat(string, locale) : new AngleFormat(string);
        FieldPosition fieldPosition = new FieldPosition(0);
        StringBuffer stringBuffer = new StringBuffer();
        angleFormat.format((Object)new Latitude(geographicBoundingBox.getNorthBoundLatitude()), stringBuffer, fieldPosition).append(", ");
        angleFormat.format((Object)new Longitude(geographicBoundingBox.getWestBoundLongitude()), stringBuffer, fieldPosition).append(" - ");
        angleFormat.format((Object)new Latitude(geographicBoundingBox.getSouthBoundLatitude()), stringBuffer, fieldPosition).append(", ");
        angleFormat.format((Object)new Longitude(geographicBoundingBox.getEastBoundLongitude()), stringBuffer, fieldPosition);
        return stringBuffer.toString();
    }

    static {
        DefaultGeographicBoundingBox defaultGeographicBoundingBox = new DefaultGeographicBoundingBox(-180.0, 180.0, -90.0, 90.0);
        defaultGeographicBoundingBox.freeze();
        WORLD = defaultGeographicBoundingBox;
    }
}

