/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.citation;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.jaxb.MarshalContext;
import org.geotoolkit.internal.jaxb.NonMarshalledAuthority;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.geotoolkit.util.SimpleInternationalString;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.xml.IdentifierSpace;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Series;
import org.opengis.util.InternationalString;

@ThreadSafe
@XmlType(name="CI_Citation_Type", propOrder={"title", "alternateTitles", "dates", "edition", "editionDate", "identifiers", "citedResponsibleParties", "presentationForms", "series", "otherCitationDetails", "collectiveTitle", "ISBN", "ISSN"})
@XmlRootElement(name="CI_Citation")
public class DefaultCitation
extends MetadataEntity
implements Citation {
    private static final long serialVersionUID = 2595269795652984755L;
    static final IdentifierSpace<String> ISBN = new NonMarshalledAuthority("ISBN", 5);
    static final IdentifierSpace<String> ISSN = new NonMarshalledAuthority("ISSN", 4);
    private InternationalString title;
    private Collection<InternationalString> alternateTitles;
    private Collection<CitationDate> dates;
    private InternationalString edition;
    private long editionDate;
    private Collection<ResponsibleParty> citedResponsibleParties;
    private Collection<PresentationForm> presentationForms;
    private Series series;
    private InternationalString otherCitationDetails;
    private InternationalString collectiveTitle;

    public DefaultCitation() {
        this.editionDate = Long.MIN_VALUE;
    }

    public DefaultCitation(Citation citation) {
        super(citation);
        if (citation != null && this.editionDate == 0L && citation.getEditionDate() == null) {
            this.editionDate = Long.MIN_VALUE;
        }
    }

    public DefaultCitation(CharSequence charSequence) {
        this();
        if (charSequence != null) {
            this.setTitle(SimpleInternationalString.wrap((CharSequence)charSequence));
        }
    }

    public DefaultCitation(ResponsibleParty responsibleParty) {
        this();
        if (responsibleParty != null) {
            String string;
            InternationalString internationalString = responsibleParty.getOrganisationName();
            if (internationalString == null && (internationalString = responsibleParty.getPositionName()) == null && (string = responsibleParty.getIndividualName()) != null) {
                internationalString = new SimpleInternationalString(string);
            }
            this.setTitle(internationalString);
            this.setCitedResponsibleParties(Collections.singleton(responsibleParty));
        }
    }

    public static DefaultCitation castOrCopy(Citation citation) {
        return citation == null || citation instanceof DefaultCitation ? (DefaultCitation)citation : new DefaultCitation(citation);
    }

    @XmlElement(name="title", required=true)
    public synchronized InternationalString getTitle() {
        return this.title;
    }

    public synchronized void setTitle(InternationalString internationalString) {
        this.checkWritePermission();
        this.title = internationalString;
    }

    @XmlElement(name="alternateTitle")
    public synchronized Collection<InternationalString> getAlternateTitles() {
        this.alternateTitles = this.nonNullCollection(this.alternateTitles, InternationalString.class);
        return this.alternateTitles;
    }

    public synchronized void setAlternateTitles(Collection<? extends InternationalString> collection) {
        this.alternateTitles = this.copyCollection(collection, this.alternateTitles, InternationalString.class);
    }

    @XmlElement(name="date", required=true)
    public synchronized Collection<CitationDate> getDates() {
        this.dates = this.nonNullCollection(this.dates, CitationDate.class);
        return this.dates;
    }

    public synchronized void setDates(Collection<? extends CitationDate> collection) {
        this.dates = this.copyCollection(collection, this.dates, CitationDate.class);
    }

    @XmlElement(name="edition")
    public synchronized InternationalString getEdition() {
        return this.edition;
    }

    public synchronized void setEdition(InternationalString internationalString) {
        this.checkWritePermission();
        this.edition = internationalString;
    }

    @XmlElement(name="editionDate")
    public synchronized Date getEditionDate() {
        return this.editionDate != Long.MIN_VALUE ? new Date(this.editionDate) : null;
    }

    public synchronized void setEditionDate(Date date) {
        this.checkWritePermission();
        this.editionDate = date != null ? date.getTime() : Long.MIN_VALUE;
    }

    @Override
    @XmlElement(name="identifier")
    public Collection<Identifier> getIdentifiers() {
        return MarshalContext.filterIdentifiers(super.getIdentifiers());
    }

    public synchronized void setIdentifiers(Collection<? extends Identifier> collection) {
        Collection collection2 = NonMarshalledAuthority.getIdentifiers((Collection)this.identifiers);
        this.identifiers = this.copyCollection(collection, this.identifiers, Identifier.class);
        NonMarshalledAuthority.setIdentifiers((Collection)this.identifiers, (Collection)collection2);
    }

    @XmlElement(name="citedResponsibleParty")
    public synchronized Collection<ResponsibleParty> getCitedResponsibleParties() {
        this.citedResponsibleParties = this.nonNullCollection(this.citedResponsibleParties, ResponsibleParty.class);
        return this.citedResponsibleParties;
    }

    public synchronized void setCitedResponsibleParties(Collection<? extends ResponsibleParty> collection) {
        this.citedResponsibleParties = this.copyCollection(collection, this.citedResponsibleParties, ResponsibleParty.class);
    }

    @XmlElement(name="presentationForm")
    public synchronized Collection<PresentationForm> getPresentationForms() {
        this.presentationForms = this.nonNullCollection(this.presentationForms, PresentationForm.class);
        return this.presentationForms;
    }

    public synchronized void setPresentationForms(Collection<? extends PresentationForm> collection) {
        this.presentationForms = this.copyCollection(collection, this.presentationForms, PresentationForm.class);
    }

    @XmlElement(name="series")
    public synchronized Series getSeries() {
        return this.series;
    }

    public synchronized void setSeries(Series series) {
        this.checkWritePermission();
        this.series = series;
    }

    @XmlElement(name="otherCitationDetails")
    public synchronized InternationalString getOtherCitationDetails() {
        return this.otherCitationDetails;
    }

    public synchronized void setOtherCitationDetails(InternationalString internationalString) {
        this.checkWritePermission();
        this.otherCitationDetails = internationalString;
    }

    @XmlElement(name="collectiveTitle")
    public synchronized InternationalString getCollectiveTitle() {
        return this.collectiveTitle;
    }

    public synchronized void setCollectiveTitle(InternationalString internationalString) {
        this.checkWritePermission();
        this.collectiveTitle = internationalString;
    }

    @XmlElement(name="ISBN")
    public synchronized String getISBN() {
        return XCollections.isNullOrEmpty((Collection)this.identifiers) ? null : (String)this.getIdentifierMap().getSpecialized(ISBN);
    }

    public synchronized void setISBN(String string) {
        this.checkWritePermission();
        if (string != null || !XCollections.isNullOrEmpty((Collection)this.identifiers)) {
            this.getIdentifierMap().putSpecialized(ISBN, (Object)string);
        }
    }

    @XmlElement(name="ISSN")
    public synchronized String getISSN() {
        return XCollections.isNullOrEmpty((Collection)this.identifiers) ? null : (String)this.getIdentifierMap().getSpecialized(ISSN);
    }

    public synchronized void setISSN(String string) {
        this.checkWritePermission();
        if (string != null || !XCollections.isNullOrEmpty((Collection)this.identifiers)) {
            this.getIdentifierMap().putSpecialized(ISSN, (Object)string);
        }
    }
}

