/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.citation;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.metadata.iso.DefaultIdentifier;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.metadata.iso.citation.DefaultCitation;
import org.geotoolkit.util.SimpleInternationalString;
import org.geotoolkit.xml.IdentifierSpace;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;

@ThreadSafe
class CitationConstant
extends DefaultCitation {
    private static final long serialVersionUID = -2997857814910523464L;
    private final Serialized replacement;

    CitationConstant(CharSequence charSequence, String string, String string2) {
        super(charSequence);
        this.replacement = new Serialized(string);
        this.setIdentifier(string2);
    }

    CitationConstant(ResponsibleParty responsibleParty, String string, String string2) {
        super(responsibleParty);
        this.replacement = new Serialized(string);
        this.setIdentifier(string2);
    }

    final void setAlternateTitle(String string) {
        assert (!string.equals(this.getTitle().toString(null))) : string;
        this.setAlternateTitles(Collections.singleton(new SimpleInternationalString(string)));
    }

    private void setIdentifier(String string) {
        if (string != null) {
            this.setIdentifiers(Collections.singleton(new DefaultIdentifier(string)));
        }
    }

    final void setPresentationForm(PresentationForm presentationForm) {
        this.setPresentationForms(Collections.singleton(presentationForm));
    }

    @Override
    protected final DefaultCitation clone() {
        return new DefaultCitation(this);
    }

    protected final Object writeReplace() throws ObjectStreamException {
        return this.replacement;
    }

    private static class Serialized
    implements Serializable {
        private static final long serialVersionUID = 6177391499370692010L;
        private final String name;

        public Serialized(String string) {
            this.name = string;
        }

        protected Class<?> getContainer() {
            return Citations.class;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                return this.getContainer().getField(this.name).get(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new InvalidObjectException(noSuchFieldException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InvalidObjectException(illegalAccessException.toString());
            }
        }
    }

    static final class Authority<T>
    extends CitationConstant
    implements IdentifierSpace<T> {
        private static final long serialVersionUID = 9049409961960288134L;
        private final String namespace;

        Authority(CharSequence charSequence, String string, String string2) {
            super(charSequence, string, string2);
            this.namespace = string2;
        }

        Authority(ResponsibleParty responsibleParty, String string, String string2) {
            super(responsibleParty, string, string2);
            this.namespace = string2;
        }

        public String getName() {
            return this.namespace;
        }
    }
}

