/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.acquisition;

import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.jaxb.NonMarshalledAuthority;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.acquisition.Context;
import org.opengis.metadata.acquisition.Event;
import org.opengis.metadata.acquisition.Instrument;
import org.opengis.metadata.acquisition.Objective;
import org.opengis.metadata.acquisition.PlatformPass;
import org.opengis.metadata.acquisition.Sequence;
import org.opengis.metadata.acquisition.Trigger;

@ThreadSafe
@XmlType(name="MI_Event_Type", propOrder={"identifier", "trigger", "context", "sequence", "time", "expectedObjectives", "relatedPass", "relatedSensors"})
@XmlRootElement(name="MI_Event")
public class DefaultEvent
extends MetadataEntity
implements Event {
    private static final long serialVersionUID = -5625600499628778407L;
    private Trigger trigger;
    private Context context;
    private Sequence sequence;
    private long time;
    private Collection<Objective> expectedObjectives;
    private PlatformPass relatedPass;
    private Collection<Instrument> relatedSensors;

    public DefaultEvent() {
        this.time = Long.MIN_VALUE;
    }

    public DefaultEvent(Event event) {
        super(event);
        if (event != null && this.time == 0L && event.getTime() == null) {
            this.time = Long.MIN_VALUE;
        }
    }

    public static DefaultEvent castOrCopy(Event event) {
        return event == null || event instanceof DefaultEvent ? (DefaultEvent)event : new DefaultEvent(event);
    }

    @Override
    @XmlElement(name="identifier", required=true)
    public Identifier getIdentifier() {
        return super.getIdentifier();
    }

    public synchronized void setIdentifier(Identifier identifier) {
        this.checkWritePermission();
        NonMarshalledAuthority.setMarshallable(super.getIdentifiers(), (Identifier)identifier);
    }

    @XmlElement(name="trigger", required=true)
    public synchronized Trigger getTrigger() {
        return this.trigger;
    }

    public synchronized void setTrigger(Trigger trigger) {
        this.checkWritePermission();
        this.trigger = trigger;
    }

    @XmlElement(name="context", required=true)
    public synchronized Context getContext() {
        return this.context;
    }

    public synchronized void setContext(Context context) {
        this.checkWritePermission();
        this.context = context;
    }

    @XmlElement(name="sequence", required=true)
    public synchronized Sequence getSequence() {
        return this.sequence;
    }

    public synchronized void setSequence(Sequence sequence) {
        this.checkWritePermission();
        this.sequence = sequence;
    }

    @XmlElement(name="time", required=true)
    public synchronized Date getTime() {
        long l = this.time;
        return l != Long.MIN_VALUE ? new Date(l) : null;
    }

    public synchronized void setTime(Date date) {
        this.checkWritePermission();
        this.time = date != null ? date.getTime() : Long.MIN_VALUE;
    }

    @XmlElement(name="expectedObjective")
    public synchronized Collection<Objective> getExpectedObjectives() {
        this.expectedObjectives = this.nonNullCollection(this.expectedObjectives, Objective.class);
        return this.expectedObjectives;
    }

    public synchronized void setExpectedObjectives(Collection<? extends Objective> collection) {
        this.expectedObjectives = this.copyCollection(collection, this.expectedObjectives, Objective.class);
    }

    @XmlElement(name="relatedPass")
    public synchronized PlatformPass getRelatedPass() {
        return this.relatedPass;
    }

    public synchronized void setRelatedPass(PlatformPass platformPass) {
        this.relatedPass = platformPass;
    }

    @XmlElement(name="relatedSensor")
    public synchronized Collection<? extends Instrument> getRelatedSensors() {
        this.relatedSensors = this.nonNullCollection(this.relatedSensors, Instrument.class);
        return this.relatedSensors;
    }

    public synchronized void setRelatedSensors(Collection<? extends Instrument> collection) {
        this.relatedSensors = this.copyCollection(collection, this.relatedSensors, Instrument.class);
    }
}

