/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.geotoolkit.gui.swing.tree.DefaultMutableTreeNode;
import org.geotoolkit.gui.swing.tree.NamedTreeNode;
import org.geotoolkit.gui.swing.tree.TreeFormat;
import org.geotoolkit.gui.swing.tree.TreeTableNode;
import org.geotoolkit.gui.swing.tree.Trees;
import org.geotoolkit.internal.CodeLists;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.internal.jaxb.NonMarshalledAuthority;
import org.geotoolkit.metadata.AbstractMetadata;
import org.geotoolkit.metadata.KeyNamePolicy;
import org.geotoolkit.metadata.MetadataStandard;
import org.geotoolkit.metadata.NullValuePolicy;
import org.geotoolkit.metadata.PropertyAccessor;
import org.geotoolkit.metadata.PropertyMap;
import org.geotoolkit.metadata.PropertyTreeNode;
import org.geotoolkit.metadata.TypeValuePolicy;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.MeasurementRange;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.collection.CheckedContainer;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.converter.Numbers;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.content.Band;
import org.opengis.metadata.spatial.GridSpatialRepresentation;
import org.opengis.util.CodeList;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class MetadataTreeFormat
extends Format {
    private static final long serialVersionUID = -3603011614118221049L;
    static final char OPEN_BRACKET = '[';
    static final char CLOSE_BRACKET = ']';
    private static final int TITLE_LIMIT = 40;
    private static final Class<?>[] TITLE_TYPES = new Class[]{GenericName.class, InternationalString.class, CharSequence.class, CodeList.class, Object.class};
    protected final MetadataStandard standard;
    protected final Locale displayLocale;
    protected final Locale formatLocale;
    private transient Format numberFormat;
    private transient Format dateFormat;
    private transient Format treeFormat;

    public MetadataTreeFormat(MetadataStandard metadataStandard) {
        this.standard = metadataStandard;
        this.formatLocale = this.displayLocale = Locale.getDefault();
    }

    public MetadataTreeFormat(MetadataStandard metadataStandard, Locale locale) {
        this.standard = metadataStandard;
        this.displayLocale = locale;
        this.formatLocale = locale;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        string = string.substring(n);
        try {
            Object object = this.parseObject(string);
            parsePosition.setIndex(n + string.length());
            return object;
        }
        catch (ParseException parseException) {
            parsePosition.setErrorIndex(n + parseException.getErrorOffset());
            return null;
        }
    }

    @Override
    public Object parseObject(String string) throws ParseException {
        return this.parse((TreeNode)this.getFormat(TreeFormat.class).parseObject(string));
    }

    public Object parse(TreeNode treeNode) throws ParseException {
        Object object = treeNode;
        if (treeNode instanceof NamedTreeNode) {
            object = ((NamedTreeNode)treeNode).getName();
        }
        Object obj = MetadataTreeFormat.newInstance(this.standard.getImplementation(this.getTypeForName(object.toString())));
        this.parse(treeNode, obj);
        return obj;
    }

    final void parse(TreeNode treeNode, Object object) throws ParseException {
        Class<?> clazz = object.getClass();
        PropertyAccessor propertyAccessor = this.standard.getAccessorOptional(clazz);
        if (propertyAccessor == null) {
            throw new ParseException(Errors.format((int)226, clazz), 0);
        }
        int n = this.parse(treeNode, clazz, object, null, propertyAccessor);
        if (n != 0) {
            LogRecord logRecord = Errors.getResources((Locale)this.displayLocale).getLogRecord(Level.WARNING, 54, (Object)n);
            logRecord.setSourceClassName("MetadataTreeFormat");
            logRecord.setSourceMethodName("parse");
            logRecord.setLoggerName(AbstractMetadata.LOGGER.getName());
            AbstractMetadata.LOGGER.log(logRecord);
        }
    }

    private <T> int parse(TreeNode treeNode, Class<? extends T> clazz, T t, Collection<? super T> collection, PropertyAccessor propertyAccessor) throws ParseException {
        int n = 0;
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = treeNode.getChildCount();
        for (int i = 0; i < n2; ++i) {
            Object object;
            int n3;
            TreeNode treeNode2 = treeNode.getChildAt(i);
            String string = treeNode2.toString().trim();
            if (collection != null && MetadataTreeFormat.isCollectionElement(string)) {
                n += this.parse(treeNode2, clazz, null, collection, propertyAccessor);
                continue;
            }
            if (!hashSet.add(string)) {
                if (collection == null) {
                    throw new ParseException(Errors.format((int)55, (Object)string), 0);
                }
                assert (t != null) : hashSet;
                if (!collection.add(t)) {
                    ++n;
                }
                hashSet.clear();
                hashSet.add(string);
                t = null;
            }
            if ((n3 = propertyAccessor.indexOf(string)) < 0) {
                throw new ParseException(Errors.format((int)224, (Object)string), 0);
            }
            Class<?> clazz2 = propertyAccessor.type(n3, TypeValuePolicy.ELEMENT_TYPE);
            if (clazz2 == null) {
                throw new ParseException(Errors.format((int)223, (Object)string), 0);
            }
            PropertyAccessor propertyAccessor2 = this.standard.getAccessorOptional(clazz2 = this.standard.getImplementation(clazz2));
            if (propertyAccessor2 != null) {
                object = propertyAccessor.get(n3, t);
                if (object instanceof Collection) {
                    Collection collection2 = (Collection)object;
                    n += this.parse(treeNode2, clazz2, null, collection2, propertyAccessor2);
                } else {
                    n += this.parse(treeNode2, clazz2, object, null, propertyAccessor2);
                }
            } else {
                int n4 = treeNode2.getChildCount();
                Object[] objectArray = new Object[n4];
                for (int j = 0; j < n4; ++j) {
                    TreeNode treeNode3 = treeNode2.getChildAt(j);
                    object = MetadataTreeFormat.getUserObject(treeNode3, clazz2);
                    if (object == null) {
                        String string2 = treeNode3.toString();
                        object = Number.class.isAssignableFrom(clazz2) ? this.getFormat(NumberFormat.class).parse(string2) : (Date.class.isAssignableFrom(clazz2) ? this.getFormat(DateFormat.class).parse(string2) : string2);
                    }
                    objectArray[j] = object;
                }
                object = Arrays.asList(objectArray);
            }
            if (t == null) {
                t = MetadataTreeFormat.newInstance(clazz);
            }
            propertyAccessor.set(n3, t, object, false);
        }
        if (collection != null && t != null && !collection.add(t)) {
            ++n;
        }
        return n;
    }

    private static Object getUserObject(TreeNode treeNode, Class<?> clazz) {
        Object object = Trees.getUserObject((TreeNode)treeNode);
        return clazz.isInstance(object) ? object : null;
    }

    private static <T> T newInstance(Class<? extends T> clazz) throws ParseException {
        try {
            return clazz.newInstance();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            ParseException parseException = new ParseException(Errors.format((int)27, clazz), 0);
            parseException.initCause(exception);
            throw parseException;
        }
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        ArgumentChecks.ensureNonNull((String)"metadata", (Object)object);
        return this.getFormat(TreeFormat.class).format((Object)this.asTree(object), stringBuffer, fieldPosition);
    }

    public org.geotoolkit.gui.swing.tree.MutableTreeNode asTree(Object object) {
        Class<?> clazz = this.standard.getInterface(object.getClass());
        NamedTreeNode namedTreeNode = new NamedTreeNode(this.formatElementName(clazz, null), object);
        this.append((DefaultMutableTreeNode)namedTreeNode, object, 0);
        return namedTreeNode;
    }

    public TreeTableNode asTreeTable(Object object) {
        Class<?> clazz = this.standard.getInterface(object.getClass());
        PropertyTreeNode propertyTreeNode = new PropertyTreeNode(this.formatElementName(clazz, null), object);
        this.append((DefaultMutableTreeNode)propertyTreeNode, object, 0);
        return propertyTreeNode;
    }

    /*
     * WARNING - void declaration
     */
    private void append(DefaultMutableTreeNode defaultMutableTreeNode, Object object, int n) {
        PropertyMap propertyMap;
        if (object == null) {
            return;
        }
        if (object instanceof Map) {
            propertyMap = (PropertyMap)object;
        } else if (object instanceof AbstractMetadata) {
            propertyMap = ((AbstractMetadata)object).asMap();
        } else {
            PropertyAccessor propertyAccessor = this.standard.getAccessorOptional(object.getClass());
            if (propertyAccessor != null) {
                propertyMap = new PropertyMap(object, propertyAccessor, NullValuePolicy.NON_EMPTY, KeyNamePolicy.JAVABEANS_PROPERTY);
            } else {
                NamedTreeNode namedTreeNode;
                if (object instanceof Collection) {
                    void var9_17;
                    Object[] objectArray = ((Collection)object).toArray();
                    int n2 = 0;
                    for (Object object2 : objectArray) {
                        if (MetadataTreeFormat.ignore(object2)) continue;
                        objectArray[n2++] = object2;
                    }
                    int n4 = n2 > 1 ? 1 : 0;
                    boolean object3 = false;
                    while (var9_17 < n2) {
                        this.append(defaultMutableTreeNode, objectArray[var9_17], n4);
                        if (n4 != 0) {
                            ++n4;
                        }
                        ++var9_17;
                    }
                    return;
                }
                String string = object instanceof CodeList ? this.formatCodeList((CodeList)object) : (object instanceof Date ? this.getFormat(DateFormat.class).format((Date)object) : (object instanceof Number ? this.formatNumber((Number)object) : (object instanceof InternationalString ? ((InternationalString)object).toString(this.displayLocale) : (object instanceof Locale ? ((Locale)object).getDisplayName(this.displayLocale) : String.valueOf(object)))));
                if (defaultMutableTreeNode instanceof PropertyTreeNode) {
                    if (n == 0) {
                        ((PropertyTreeNode)defaultMutableTreeNode).valueAsText = string;
                        defaultMutableTreeNode.setUserObject(object);
                        return;
                    }
                    namedTreeNode = new PropertyTreeNode(this.formatNumber(n), string, object);
                } else {
                    assert (!MetadataTreeFormat.isCollectionElement(string)) : string;
                    namedTreeNode = new NamedTreeNode((CharSequence)string, object, false);
                }
                defaultMutableTreeNode.add((MutableTreeNode)namedTreeNode);
                return;
            }
        }
        Class<?> clazz = object.getClass();
        if (this.standard.isMetadata(clazz)) {
            clazz = this.standard.getInterface(clazz);
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
        if (n != 0) {
            void var9_20;
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append('[').append(this.formatNumber(n)).append(']').append(' ');
            stringBuilder.append(Strings.camelCaseToSentence((CharSequence)Classes.getShortName(clazz)));
            String string = MetadataTreeFormat.getTitleForSpecialCases(object);
            if (string == null) {
                String string2 = this.getTitle(propertyMap.values());
            }
            if (var9_20 != null) {
                void var9_22;
                boolean bl;
                boolean bl2 = bl = var9_20.length() > 40;
                if (bl) {
                    String string3 = var9_20.substring(0, 40);
                }
                stringBuilder.append(" \u2012 ").append((String)var9_22);
                if (bl) {
                    stringBuilder.append('\u2026');
                }
            }
            String string4 = stringBuilder.toString();
            assert (MetadataTreeFormat.isCollectionElement(string4)) : string4;
            defaultMutableTreeNode2 = new NamedTreeNode((CharSequence)string4, object);
            defaultMutableTreeNode.add((MutableTreeNode)defaultMutableTreeNode2);
        }
        for (Map.Entry entry : propertyMap.entrySet()) {
            Object v = entry.getValue();
            if (MetadataTreeFormat.ignore(v)) continue;
            CharSequence charSequence = this.formatElementName(clazz, (String)entry.getKey());
            assert (!MetadataTreeFormat.isCollectionElement(((Object)charSequence).toString())) : charSequence;
            PropertyTreeNode propertyTreeNode = defaultMutableTreeNode instanceof PropertyTreeNode ? new PropertyTreeNode(charSequence, v) : new NamedTreeNode(charSequence, v);
            this.append((DefaultMutableTreeNode)propertyTreeNode, v, 0);
            defaultMutableTreeNode2.add((MutableTreeNode)((Object)propertyTreeNode));
        }
    }

    private static boolean isCollectionElement(String string) {
        int n;
        int n2 = string.indexOf(91);
        if (n2 >= 0 && (n = string.indexOf(93, n2)) > n2) {
            while (--n2 >= 0) {
                if (!Character.isJavaIdentifierPart(string.charAt(n2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String getTitleForSpecialCases(Object object) {
        Object object2;
        if (object instanceof Band && (object2 = (Band)object).getSequenceIdentifier() == null) {
            Double d = object2.getMinValue();
            Double d2 = object2.getMaxValue();
            if (d != null || d2 != null) {
                return new MeasurementRange(Double.class, (Number)d, true, (Number)d2, true, object2.getUnits()).toString();
            }
        }
        if (object instanceof GridSpatialRepresentation) {
            object2 = null;
            for (Double d2 : ((GridSpatialRepresentation)object).getAxisDimensionProperties()) {
                Integer n = d2.getDimensionSize();
                if (n == null) continue;
                if (object2 == null) {
                    object2 = new StringBuilder(16);
                } else {
                    ((StringBuilder)object2).append('\u00d7');
                }
                ((StringBuilder)object2).append(n);
            }
            if (object2 != null) {
                return ((StringBuilder)object2).toString();
            }
        }
        return null;
    }

    private String getTitle(Collection<?> collection) {
        String string = null;
        for (int i = 0; i < TITLE_TYPES.length - 1; ++i) {
            Class<?> clazz = TITLE_TYPES[i];
            for (Object obj : collection) {
                InternationalString object;
                String string2;
                if (!clazz.isInstance(obj) || (string2 = obj instanceof GenericName ? ((object = ((GenericName)obj).toInternationalString()) != null ? object.toString(this.displayLocale) : obj.toString()) : (obj instanceof InternationalString ? ((InternationalString)obj).toString(this.displayLocale) : (obj instanceof CodeList ? CodeLists.localize((CodeList)((CodeList)obj), (Locale)this.displayLocale) : obj.toString()))) == null || (string2 = string2.trim()).isEmpty() || string != null && string2.length() >= string.length()) continue;
                string = string2;
            }
            if (string == null) continue;
            return string;
        }
        Collection[] collectionArray = new Collection[collection.size()];
        int n = 0;
        for (Object obj : collection) {
            if (!(obj instanceof Collection)) continue;
            collectionArray[n++] = (Collection)obj;
        }
        for (Class<?> clazz : TITLE_TYPES) {
            if (n == 0) break;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Collection collection2 = collectionArray[i];
                if (clazz.isAssignableFrom(collection2 instanceof CheckedContainer ? ((CheckedContainer)collection2).getElementType() : Object.class)) {
                    String string2 = this.getTitle(collection2);
                    if (string2 == null || string != null && string2.length() >= string.length()) continue;
                    string = string2;
                    continue;
                }
                collectionArray[n2++] = collection2;
            }
            n = n2;
            if (string == null) continue;
            return string;
        }
        return null;
    }

    private <T extends Format> T getFormat(Class<T> clazz) {
        Format format;
        String string = clazz.getSimpleName();
        if (string.equals("DateFormat")) {
            format = this.dateFormat;
        } else if (string.equals("NumberFormat")) {
            format = this.numberFormat;
        } else if (string.equals("TreeFormat")) {
            format = this.treeFormat;
        } else {
            throw new AssertionError(clazz);
        }
        if (format == null) {
            if (string.equals("DateFormat")) {
                format = DateFormat.getDateTimeInstance(1, 1, this.formatLocale);
            } else if (string.equals("NumberFormat")) {
                format = NumberFormat.getNumberInstance(this.formatLocale);
            } else if (string.equals("TreeFormat")) {
                format = new TreeFormat();
            } else {
                throw new AssertionError(clazz);
            }
        }
        return (T)format;
    }

    protected String formatNumber(Number number) {
        NumberFormat numberFormat = this.getFormat(NumberFormat.class);
        if (Numbers.isInteger(number.getClass())) {
            numberFormat.setMaximumFractionDigits(0);
        } else {
            InternalUtilities.configure((NumberFormat)numberFormat, (double)number.doubleValue(), (int)12);
        }
        return numberFormat.format(number);
    }

    private static boolean ignoreElement(Object object) {
        return PropertyAccessor.isEmpty(object) || object instanceof Identifier && ((Identifier)object).getAuthority() instanceof NonMarshalledAuthority;
    }

    private static boolean ignore(Object object) {
        if (MetadataTreeFormat.ignoreElement(object)) {
            return true;
        }
        if (!(object instanceof Iterable)) {
            return false;
        }
        for (Object t : (Iterable)object) {
            if (MetadataTreeFormat.ignoreElement(t)) continue;
            return false;
        }
        return true;
    }

    protected String formatCodeList(CodeList<?> codeList) {
        return codeList.name().trim().replace('_', ' ').toLowerCase(this.displayLocale);
    }

    protected CharSequence formatElementName(Class<?> clazz, String string) {
        int n;
        if (string == null) {
            string = Classes.getShortName(clazz);
        }
        if ((n = (string = string.trim()).length()) != 0) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + 8);
            stringBuilder.append(Character.toUpperCase(string.charAt(0)));
            boolean bl = true;
            int n2 = 1;
            for (int i = 1; i < n; ++i) {
                boolean bl2 = Character.isUpperCase(string.charAt(i));
                if (bl2 != bl) {
                    int n3 = i;
                    if (bl) {
                        --n3;
                    }
                    if (n3 > n2) {
                        stringBuilder.append(string, n2, n3).append(' ');
                        n2 = n3;
                    }
                }
                bl = bl2;
            }
            String string2 = stringBuilder.append(string, n2, string.length()).toString();
            if (!string2.equals(string)) {
                string = string2;
            }
        }
        return string;
    }

    protected Class<?> getTypeForName(String string) throws ParseException {
        if (this.standard == MetadataStandard.ISO_19115) {
            if (string.equals("Metadata")) {
                return Metadata.class;
            }
            if (string.equals("Citation")) {
                return Citation.class;
            }
        }
        throw new ParseException(Errors.format((int)226, (Object)string), 0);
    }
}

