/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.metadata.FactoryMethod;
import org.geotoolkit.metadata.MetadataStandard;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.util.FactoryException;

@ThreadSafe
public class MetadataFactory
extends Factory {
    private final Object[] factories;
    private final MetadataStandard[] standards;
    private final Map<Class<?>, FactoryMethod> factoryMethods;

    public MetadataFactory() {
        this(MetadataFactory.factories(), MetadataStandard.ISO_19115);
    }

    public MetadataFactory(MetadataStandard ... metadataStandardArray) {
        this(MetadataFactory.factories(), metadataStandardArray);
    }

    public MetadataFactory(Set<?> set, MetadataStandard ... metadataStandardArray) {
        if (!XCollections.isNullOrEmpty(set)) {
            this.factories = set.toArray();
            this.factoryMethods = new HashMap();
        } else {
            this.factories = null;
            this.factoryMethods = null;
        }
        this.standards = (MetadataStandard[])metadataStandardArray.clone();
    }

    private static Set<?> factories() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        int n = 0;
        while (true) {
            Set set;
            switch (n) {
                case 0: {
                    set = FactoryFinder.getDatumFactories(null);
                    break;
                }
                case 1: {
                    set = FactoryFinder.getCSFactories(null);
                    break;
                }
                case 2: {
                    set = FactoryFinder.getCRSFactories(null);
                    break;
                }
                default: {
                    return linkedHashSet;
                }
            }
            Iterator iterator = set.iterator();
            if (iterator.hasNext()) {
                linkedHashSet.add(iterator.next());
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T create(Class<T> clazz, Map<String, ?> map) throws FactoryException {
        Object object;
        if (this.factoryMethods != null) {
            Map<Class<?>, FactoryMethod> map2 = this.factoryMethods;
            synchronized (map2) {
                object = this.factoryMethods.get(clazz);
                if (object == null) {
                    object = FactoryMethod.find(clazz, this.factories);
                    if (object == null) {
                        object = FactoryMethod.NULL;
                    } else {
                        for (FactoryMethod factoryMethod : this.factoryMethods.values()) {
                            if (!((FactoryMethod)object).equals(factoryMethod)) continue;
                            object = factoryMethod;
                            break;
                        }
                    }
                    this.factoryMethods.put(clazz, (FactoryMethod)object);
                }
            }
            Object object2 = ((FactoryMethod)object).create(map);
            if (object2 != null) {
                return clazz.cast(object2);
            }
        }
        object = null;
        for (MetadataStandard metadataStandard : this.standards) {
            Object obj;
            if (!metadataStandard.isMetadata(clazz)) continue;
            Class<?> clazz2 = metadataStandard.getImplementation(clazz);
            try {
                obj = clazz2.newInstance();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                if (object != null && !(object instanceof InstantiationException)) continue;
                object = exception;
                continue;
            }
            Map<String, Object> map3 = metadataStandard.asMap(obj);
            try {
                map3.putAll(map);
            }
            catch (RuntimeException runtimeException) {
                throw new FactoryException(runtimeException.getLocalizedMessage(), (Throwable)runtimeException);
            }
            return clazz.cast(obj);
        }
        throw new FactoryException(Errors.format((int)226, clazz), (Throwable)object);
    }
}

