/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.opengis.util.FactoryException;

@Immutable
final class FactoryMethod {
    static final FactoryMethod NULL = new FactoryMethod(null, null);
    private final Method method;
    private final Object factory;

    private FactoryMethod(Method method, Object object) {
        this.method = method;
        this.factory = object;
    }

    static FactoryMethod find(Class<?> clazz, Object[] objectArray) {
        for (Object object : objectArray) {
            for (Method method : object.getClass().getMethods()) {
                Type type;
                Type[] typeArray;
                String string;
                if (method.isSynthetic() || method.isAnnotationPresent(Deprecated.class) || !(string = method.getName()).startsWith("create") || !clazz.isAssignableFrom(method.getReturnType()) || (typeArray = method.getGenericParameterTypes()).length == 0 || (type = typeArray[0]) == Map.class || !(type instanceof ParameterizedType) || (typeArray = ((ParameterizedType)type).getActualTypeArguments()).length != 2 || !FactoryMethod.bounds(typeArray[0]).isAssignableFrom(String.class) || !FactoryMethod.bounds(typeArray[1]).isAssignableFrom(Object.class)) continue;
                return new FactoryMethod(method, object);
            }
        }
        return null;
    }

    private static Class<?> bounds(Type type) {
        while (type instanceof WildcardType) {
            Type[] typeArray = ((WildcardType)type).getUpperBounds();
            if (typeArray.length != 1) continue;
            type = typeArray[0];
        }
        return (Class)type;
    }

    Object create(Map<String, ?> map) throws FactoryException {
        if (this.method == null) {
            return null;
        }
        Class<?>[] classArray = this.method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        if (classArray.length > 1) {
            LinkedHashMap linkedHashMap = new LinkedHashMap(map);
            map = linkedHashMap;
            block3: for (int i = 1; i < classArray.length; ++i) {
                Class<?> clazz = classArray[i];
                Iterator iterator = linkedHashMap.values().iterator();
                while (iterator.hasNext()) {
                    Object v = iterator.next();
                    if (!clazz.isInstance(v)) continue;
                    objectArray[i] = v;
                    iterator.remove();
                    continue block3;
                }
            }
        }
        objectArray[0] = map;
        try {
            return this.method.invoke(this.factory, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof FactoryException) {
                throw (FactoryException)throwable;
            }
            throw new FactoryException(throwable.getLocalizedMessage(), throwable);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof FactoryMethod) {
            FactoryMethod factoryMethod = (FactoryMethod)object;
            return this.method.equals(factoryMethod.method) && this.factory == factoryMethod.factory;
        }
        return false;
    }

    public int hashCode() {
        return this.method.hashCode() ^ System.identityHashCode(this.factory);
    }
}

