/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableLongStack;
import org.eclipse.collections.api.stack.primitive.LongStack;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.LongStacks;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;

final class ImmutableLongEmptyStack
implements ImmutableLongStack,
Serializable {
    static final ImmutableLongStack INSTANCE = new ImmutableLongEmptyStack();
    private static final long serialVersionUID = 1L;

    ImmutableLongEmptyStack() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public LongIterator longIterator() {
        return ImmutableEmptyLongIterator.INSTANCE;
    }

    public void forEach(LongProcedure procedure) {
    }

    public void each(LongProcedure procedure) {
    }

    public int count(LongPredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return false;
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return true;
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return true;
    }

    public long peek() {
        throw new EmptyStackException();
    }

    public LongList peek(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return new LongArrayList(0);
        }
        throw new EmptyStackException();
    }

    public long peekAt(int index) {
        this.checkNegativeCount(index);
        throw new EmptyStackException();
    }

    public ImmutableLongStack select(LongPredicate predicate) {
        return this;
    }

    public ImmutableLongStack reject(LongPredicate predicate) {
        return this;
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return ifNone;
    }

    public <V> ImmutableStack<V> collect(LongToObjectFunction<? extends V> function) {
        return Stacks.immutable.of();
    }

    public long sum() {
        return 0L;
    }

    public long max() {
        throw new NoSuchElementException();
    }

    public long maxIfEmpty(long defaultValue) {
        return defaultValue;
    }

    public long min() {
        throw new NoSuchElementException();
    }

    public long minIfEmpty(long defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public long[] toSortedArray() {
        return new long[0];
    }

    public MutableLongList toSortedList() {
        return new LongArrayList();
    }

    public long[] toArray() {
        return new long[0];
    }

    public boolean contains(long value) {
        return false;
    }

    public boolean containsAll(long ... source) {
        return source.length == 0;
    }

    public boolean containsAll(LongIterable source) {
        return source.isEmpty();
    }

    public MutableLongList toList() {
        return new LongArrayList();
    }

    public MutableLongSet toSet() {
        return new LongHashSet();
    }

    public MutableLongBag toBag() {
        return new LongHashBag();
    }

    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter((LongIterable)this);
    }

    public ImmutableLongStack toImmutable() {
        return this;
    }

    public ImmutableLongStack push(long element) {
        return LongStacks.immutable.with(element);
    }

    public ImmutableLongStack pop() {
        throw new EmptyStackException();
    }

    public ImmutableLongStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        throw new EmptyStackException();
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof LongStack)) {
            return false;
        }
        LongStack stack = (LongStack)otherStack;
        return stack.isEmpty();
    }

    public int hashCode() {
        return 1;
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getFirst() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getFirst() not implemented yet");
    }

    public int indexOf(long value) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".indexOf() not implemented yet");
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectLongIntToObjectFunction<? super T, ? extends T> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".injectIntoWithIndex() not implemented yet");
    }

    public void forEachWithIndex(LongIntProcedure procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEachWithIndex() not implemented yet");
    }
}

