/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToByteFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToCharFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToIntFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToLongFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToShortFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.block.factory.primitive.FloatPredicates;
import org.eclipse.collections.impl.factory.primitive.FloatSets;
import org.eclipse.collections.impl.lazy.primitive.CollectFloatToBooleanIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectFloatToByteIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectFloatToCharIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectFloatToDoubleIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectFloatToFloatIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectFloatToIntIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectFloatToLongIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectFloatToShortIterable;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.utility.internal.primitive.FloatIterableIterate;
import org.eclipse.collections.impl.utility.primitive.LazyFloatIterate;

public abstract class AbstractLazyFloatIterable
implements LazyFloatIterable {
    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    public int size() {
        return this.count(FloatPredicates.alwaysTrue());
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public boolean isEmpty() {
        return FloatIterableIterate.isEmpty((FloatIterable)this);
    }

    public boolean notEmpty() {
        return FloatIterableIterate.notEmpty((FloatIterable)this);
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        FloatIterableIterate.appendString((FloatIterable)this, appendable, start, separator, end);
    }

    public boolean contains(float value) {
        return this.anySatisfy(FloatPredicates.equal(value));
    }

    public boolean containsAll(float ... source) {
        return this.containsAll((FloatIterable)FloatSets.immutable.of(source));
    }

    public boolean containsAll(FloatIterable source) {
        return source.allSatisfy((FloatPredicate & Serializable)value -> this.contains(value));
    }

    public LazyFloatIterable select(FloatPredicate predicate) {
        return LazyFloatIterate.select((FloatIterable)this, predicate);
    }

    public LazyFloatIterable reject(FloatPredicate predicate) {
        return LazyFloatIterate.select((FloatIterable)this, FloatPredicates.not(predicate));
    }

    public LazyFloatIterable tap(FloatProcedure procedure) {
        return LazyFloatIterate.tap((FloatIterable)this, procedure);
    }

    public <V> LazyIterable<V> collect(FloatToObjectFunction<? extends V> function) {
        return LazyFloatIterate.collect((FloatIterable)this, function);
    }

    public <V> LazyIterable<V> flatCollect(FloatToObjectFunction<? extends Iterable<V>> function) {
        return LazyFloatIterate.flatCollect((FloatIterable)this, function);
    }

    public LazyBooleanIterable collectBoolean(FloatToBooleanFunction function) {
        return new CollectFloatToBooleanIterable((FloatIterable)this, function);
    }

    public LazyByteIterable collectByte(FloatToByteFunction function) {
        return new CollectFloatToByteIterable((FloatIterable)this, function);
    }

    public LazyCharIterable collectChar(FloatToCharFunction function) {
        return new CollectFloatToCharIterable((FloatIterable)this, function);
    }

    public LazyShortIterable collectShort(FloatToShortFunction function) {
        return new CollectFloatToShortIterable((FloatIterable)this, function);
    }

    public LazyIntIterable collectInt(FloatToIntFunction function) {
        return new CollectFloatToIntIterable((FloatIterable)this, function);
    }

    public LazyFloatIterable collectFloat(FloatToFloatFunction function) {
        return new CollectFloatToFloatIterable((FloatIterable)this, function);
    }

    public LazyLongIterable collectLong(FloatToLongFunction function) {
        return new CollectFloatToLongIterable((FloatIterable)this, function);
    }

    public LazyDoubleIterable collectDouble(FloatToDoubleFunction function) {
        return new CollectFloatToDoubleIterable((FloatIterable)this, function);
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return FloatIterableIterate.detectIfNone((FloatIterable)this, predicate, ifNone);
    }

    public int count(FloatPredicate predicate) {
        return FloatIterableIterate.count((FloatIterable)this, predicate);
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return FloatIterableIterate.anySatisfy((FloatIterable)this, predicate);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return FloatIterableIterate.allSatisfy((FloatIterable)this, predicate);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return FloatIterableIterate.noneSatisfy((FloatIterable)this, predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return FloatIterableIterate.injectInto((FloatIterable)this, injectedValue, function);
    }

    public float[] toArray() {
        return this.toList().toArray();
    }

    public MutableFloatList toList() {
        FloatArrayList list = new FloatArrayList();
        this.forEach(arg_0 -> ((MutableFloatList)list).add(arg_0));
        return list;
    }

    public MutableFloatSet toSet() {
        FloatHashSet set = new FloatHashSet();
        this.forEach(arg_0 -> ((MutableFloatSet)set).add(arg_0));
        return set;
    }

    public MutableFloatBag toBag() {
        FloatHashBag bag = new FloatHashBag();
        this.forEach(arg_0 -> ((MutableFloatBag)bag).add(arg_0));
        return bag;
    }

    public double sum() {
        FloatSumProcedure procedure = new FloatSumProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public float max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        FloatMaxProcedure procedure = new FloatMaxProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public float maxIfEmpty(float ifEmpty) {
        if (this.isEmpty()) {
            return ifEmpty;
        }
        return this.max();
    }

    public float min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        FloatMinProcedure procedure = new FloatMinProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public float minIfEmpty(float ifEmpty) {
        if (this.isEmpty()) {
            return ifEmpty;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        float[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            float first = sortedArray[middleIndex];
            float second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public float[] toSortedArray() {
        return this.toSortedList().toArray();
    }

    public MutableFloatList toSortedList() {
        return FloatArrayList.newList((FloatIterable)this).sortThis();
    }

    public LazyFloatIterable asLazy() {
        return this;
    }

    private static final class FloatSumProcedure
    implements FloatProcedure {
        private double sum = 0.0;
        private double compensation = 0.0;

        private FloatSumProcedure() {
        }

        public void value(float each) {
            double adjustedValue = (double)each - this.compensation;
            double nextSum = this.sum + adjustedValue;
            this.compensation = nextSum - this.sum - adjustedValue;
            this.sum = nextSum;
        }

        public double getValue() {
            return this.sum;
        }
    }

    private static final class FloatMinProcedure
    implements FloatProcedure {
        private boolean visitedOnce;
        private float min;

        private FloatMinProcedure() {
        }

        public void value(float each) {
            if (this.visitedOnce) {
                if (Float.compare(each, this.min) < 0) {
                    this.min = each;
                }
            } else {
                this.min = each;
                this.visitedOnce = true;
            }
        }

        public float getValue() {
            return this.min;
        }
    }

    private static final class FloatMaxProcedure
    implements FloatProcedure {
        private boolean visitedOnce;
        private float max;

        private FloatMaxProcedure() {
        }

        public void value(float each) {
            if (this.visitedOnce) {
                if (Float.compare(this.max, each) < 0) {
                    this.max = each;
                }
            } else {
                this.max = each;
                this.visitedOnce = true;
            }
        }

        public float getValue() {
            return this.max;
        }
    }
}

