/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.impl.factory.primitive.FloatLists;
import org.eclipse.collections.impl.lazy.primitive.CollectFloatToObjectIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.SelectFloatIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LazyFloatIterate {
    private static final LazyFloatIterable EMPTY_ITERABLE = FloatLists.immutable.of().asLazy();

    private LazyFloatIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static LazyFloatIterable adapt(FloatIterable iterable) {
        return new LazyFloatIterableAdapter(iterable);
    }

    public static LazyFloatIterable select(FloatIterable iterable, FloatPredicate predicate) {
        return new SelectFloatIterable(iterable, predicate);
    }

    public static <V> LazyIterable<V> collect(FloatIterable iterable, FloatToObjectFunction<? extends V> function) {
        return new CollectFloatToObjectIterable<V>(iterable, function);
    }

    public static <V> LazyIterable<V> collectIf(FloatIterable iterable, FloatPredicate predicate, FloatToObjectFunction<? extends V> function) {
        return LazyFloatIterate.select(iterable, predicate).collect(function);
    }

    public static LazyFloatIterable empty() {
        return EMPTY_ITERABLE;
    }
}

